/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lpez, 04/2004 <mailto:jlopez@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

#include <iostream>
#include <stdlib.h>

#include <TString.h>
#include <TArrayS.h>

#include "MParList.h"
#include "MTaskList.h"
#include "MGeomCamMagic.h"
#include "MCameraDC.h"
#include "MPSFFit.h"

#include "MReadReports.h"
#include "MGeomApply.h"
#include "MPSFFitCalc.h"
#include "MEvtLoop.h"
#include "MCalibrateDC.h"

using namespace std;

int main(int argc, char *argv[])
{
    if(argc!=2 && argc!=3) 
      {
        printf("\n usage: %s filename numberEnvents \n\n",argv[0]);
        return 1;
      }
    
    UInt_t len=strlen(argv[1]);
    
    if(argv[1][len] == '/')
      {
	argv[1][len]='\0';
      }
    
    TString filename;
    filename=argv[1];

    UInt_t numEvents = 1000000;
    if(argc == 3)
      {
	len=strlen(argv[2]);
    
	if(argv[2][len] == '/')
	  {
	    argv[2][len]='\0';
	  }
	
	numEvents=atoi(argv[2]);
      }

  //
  // Create a empty Parameter List and an empty Task List
  // The tasklist is identified in the eventloop by its name
  //
  MParList  plist;
  
  MTaskList tlist;
  plist.AddToList(&tlist);


  MGeomCamMagic geomcam;
  MCameraDC     dccam;
  MPSFFit       psffit;

  plist.AddToList(&geomcam);
  plist.AddToList(&dccam);
  plist.AddToList(&psffit);

  //
  // Now setup the tasks and tasklist:
  // ---------------------------------
  //

  // Reads the trees of the root file and the analysed branches
  MReadReports read;
  read.AddTree("Currents"); 
  read.AddFile(filename);     // after the reading of the trees!!!
  read.AddToBranchList("MReportCurrents.*");

  MGeomApply geomapl;

  TString continuoslightfile = 
    "/nfs/magic/CaCodata/rootdata/Miscellaneous/Period016/2004_04_16/dc_2004_04_16_04_46_18_22368_Off3c279-2CL100.root";
  MCalibrateDC dccal;
  dccal.SetFileName(continuoslightfile);
 
  const Int_t numrings = 3;
  //  const Int_t numblind = 187;


  // 2004_02_15
  /*  const Int_t numblind = 28;
  const Short_t x[numblind] = {  8, 224, 279, 339,
			       433, 434, 435, 436, 437, 438, 439, 
			       475, 476, 477, 478, 479, 480, 481, 482,
			       523, 524, 525, 526, 527, 528, 529, 530, 531};
  */
  const Int_t numblind = 260;
  Short_t x[numblind];

  for (int i=0;i<246;i++)
    x[i+14]=i+331;
  x[0]=124;
  x[1]=123;
  x[2]=125;
  x[3]=166;
  x[4]=165;
  x[5]=88;
  x[6]=89;
  x[7]=282;
  x[8]=283;
  x[9]=226;
  x[10]=227;
  x[11]=228;
  x[12]=177;
  x[13]=178;

  const TArrayS blindpixels(numblind,(Short_t*)x);
  MPSFFitCalc psfcalc;
  //psfcalc.SetImgCleanMode(MPSFFitCalc::kRing);
  psfcalc.SetImgCleanMode(MPSFFitCalc::kCombined);
  psfcalc.SetNumRings(numrings);
  psfcalc.SetBlindPixels(blindpixels);


  tlist.AddToList(&geomapl);
  tlist.AddToList(&read);
  tlist.AddToList(&dccal, "Currents");
  tlist.AddToList(&psfcalc, "Currents");

  //
  // Create and setup the eventloop
  //
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
     
  //
  // Execute your analysis
  //

  if (!evtloop.Eventloop(numEvents))
    return kFALSE;

  //  tlist.PrintStatistics();

  cout << "RUN " << psffit.GetMeanMinorAxis() << ' ' << psffit.GetSigmaMinorAxis() << ' ' <<  psffit.GetMeanMajorAxis()  << ' ' <<  psffit.GetSigmaMajorAxis() << ' ' << psffit.GetChisquare() << endl;
  
}


