//=//////////////////////////////////////////////////////////////////////
//=
//= srreadparam                
//=
//= @file        srreadparam.h
//= @desc        Header file
//= @author      O Blanch Bigas
//= @email       blanch@ifae.es
//= @date        Wed Feb 21 17:21:26 CET 2001
//=
//=----------------------------------------------------------------------
//=
//= Created: Wed Feb 21 17:21:26 CET 2001
//= Author:  O Blanch Bigas
//= Purpose: Program for star response  simulation
//= Notes:   See files README for details
//=    
//=----------------------------------------------------------------------
//=
//= $RCSfile: srreadparam.h,v $
//= $Revision: 1.4 $
//= $Author: moralejo $ 
//= $Date: 2004-09-17 13:51:02 $
//=
//=//////////////////////////////////////////////////////////////////////

// @T \newpage

//!@section Source code of |srreadparam.h|.

/*!@"

  In this section you can find the source code for the file
  |srreadparam.h|.  This file is mainly needed by
  |srreadparam.cxx|. Here is located the definition of the commands you
  can use in the parameters file. 

  The commands now available for the parameters file are:

  @itemize
  
  @- |input_file| filename :    
  @enditemize

  @ignoreHTML
  A parameters file (a small one) looks like this:

  @endignoreHTML

@"*/

//!@{

#ifndef _srreadparam_
#define _srreadparam_

//!@}

//!@subsection Include files.

//!@{

#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <math.h>
#include <float.h>

#include "jcmacros.h"
#include "jcdebug.h"

#include "MFadcDefine.h"
#include "MTriggerDefine.h"

//!@}

//!@subsection Macro-definitions, and constants.

//!@{

// now we define the list ITEM_LIST of possible items in
// the parameters file. note that they are functions of
// T(x). we will change T(x) to be the real item or the
// string of this item when needed

#define ITEM_LIST   /* LIST OF ITEMS IN THE PARAMETERS FILE */     \
T(database_path),   /* path to store the database */               \
T(simulated_phe),   /* starfield file */                              \
T(trig_properties), /* shape for the single phe trigger response */  \
T(fadc_properties), /* shape for the single phe fadc response */ \
T(write_root),      /* write root file with some histograms */ \
T(end_file)         /* end of the parameters file */
  
#define T(x)  x             // define T() as the name as it is

enum ITEM_TYPE {
  ITEM_LIST
};

#undef T

#define T(x)  #x              // define T() as the string of x

const char *const ITEM_NAMES[] = {
  ITEM_LIST
};

#undef T

#define LINE_MAX_LENGTH  400
#define ITEM_MAX_LENGTH  40
#define PATH_MAX_LENGTH  120

//!@}

//!@subsection Prototypes of functions.

//!@{

//++
// prototypes
//--

void readparam(char * filename);
char *get_database_path(void);
void get_simulated_phe(float *lphe, float *uphe, float *pphe);
void get_trig_properties(int *shape, float *ampl, float *fwhm);
void get_fadc_properties(int *shape, float *ampl, float *fwhm);
int get_write_root();
//!@}

//!@{

#endif // ! _srreadparam_

//!@}

//=------------------------------------------------------------
//!@subsection Log of this file.

//!@{

/*
 * $Log: not supported by cvs2svn $
 * Revision 1.3  2004/09/16 16:20:13  moralejo
 * *** empty log message ***
 *
 * Revision 1.2  2001/03/05 11:02:10  blanch
 * Header file for srreadparam.cxx 1.2
 *
 * Revision 1.1  2001/02/23 10:14:13  magicsol
 * Header file for srreadparam.cxx version 1.1
 *
 */

//!@}
//=EOF
