#ifndef MARS_MMuonCalibParCalc
#define MARS_MMuonCalibParCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMuonSearchPar;
class MMuonCalibPar;
class MSrcPosCam;
class MGeomCam;
class MCerPhotEvt;

class MMuonCalibParCalc : public MTask
{
private:
    MGeomCam       *fGeomCam;
    MCerPhotEvt    *fCerPhotEvt;
    MMuonCalibPar  *fMuonCalibPar;  
    MMuonSearchPar *fMuonSearchPar; 

    Float_t fPreCuts[5];  // The values for pre cuts.

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    TString fCerPhotName;

public:
    MMuonCalibParCalc(const char *name=NULL, const char *title=NULL);

    void SetMargin(Float_t margin);
    void EnableImpactCalc();
    void DisablePreCuts();
    void SetPreCuts(Float_t radcutlow, Float_t radcuthigh, Float_t devcuthigh,
		    Float_t musizecutlow, Float_t arcphicutlow);

    void SetNameCerPhotEvt(const char *name) { fCerPhotName = name; }

    ClassDef(MMuonCalibParCalc, 0) // task to calculate muon parameters
};

#endif

