#ifndef MARS_MBadPixelsCalc
#define MARS_MBadPixelsCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MBadPixelsCam;
class MGeomCam;
class MPedPhotCam;

class MBadPixelsCalc : public MTask
{
private:
    MGeomCam      *fGeomCam;    //! Input container storing the pixel sizes
    MPedPhotCam   *fPedPhotCam; //! Input container storing the pedestal and pedestal rms of all pixels
    MBadPixelsCam *fBadPixels;  //! Output container holding the bad pixels

    Float_t fPedestalLevel;
    TString fNamePedPhotContainer; // name of the 'MPedPhotCam' container
   
    //    void CheckPedestalRMS() const;
    Bool_t CheckPedestalRms() const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

public:
    MBadPixelsCalc(const char *name=NULL, const char *title=NULL);

    void SetPedestalLevel(Float_t f) { fPedestalLevel=f; }
    void SetNamePedPhotContainer(const char *name)    { fNamePedPhotContainer = name; }

    ClassDef(MBadPixelsCalc, 1) // Task to find bad pixels (star, broken pixels, etc)
}; 

#endif
