#ifndef MARS_MHTrigLvl0
#define MARS_MHTrigLvl0

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MCerPhotEvt
#include "MCerPhotEvt.h"
#endif

class TH1D;
class MCamDisplay;
class MRawEvtData;

class MHTrigLvl0 : public MH
{
private:
    MCerPhotEvt  fSum;            // storing the sum of triggers
    Int_t        fEntries;        // number of entries in the histogram
    MGeomCam    *fCam;            // the present geometry
    MRawEvtData *fRawEvt;         //! ADC info of the current event
    MCamDisplay *fDispl;          //! the camera display
    Float_t      fPixelThreshold; // Threshold (ADC counts a.p.) to consider
                                  // a pixel as "fired".

public:
    MHTrigLvl0(const Float_t pixelthreshold = 0, 
	       const char *name=NULL, const char *title=NULL);
    ~MHTrigLvl0();

    void Clear();

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    const MCerPhotEvt &GetSum() const { return fSum; }

    void Draw(Option_t *opt="");
    void Paint(Option_t *option="");

    ClassDef(MHTrigLvl0, 1) // Histogram to sum level 0 triggers in all pixels
};

#endif
