/*-----------------------------------------------------------------------------
mbx.h -- Synchronization of mailbox access

Copyright (c) 1995 JANZ Computer AG
All Rights Reserved

Created 96/01/23 by Stefan Althoefer
Version 1.4 of 96/07/26

Two processes -- local and peer -- communicate via mailboxes.
There are two mailboxes for each direction. Thus there are four
mailboxes altogether referred to by indexes 0,1,2,3.

To synchronize read-write access to the mailboxes two synchronization
bytes are used. These bytes are located in shared memory readable by
both processes. One byte is owned by the local process the other by
the (remote) peer process. Only the owner of a synchronization byte
may write it.

There are two functions for the local process to manipulate the
synchronization bytes: msync_get() and msync_unget().
With msync_get(1) (resp. msync_get(0)) the local process requests a
mailbox for writing (resp. reading). The index "index" of the next box
ready for writing (resp. for reading) is returned. The value -1 is
returned if there is no such box. After using the box the local process
calls msync_unget(writing, index) making the box available to the peer.

The functions are declared static. This file is meant to included in
the file where reading and writing mailboxes is done.
It is necessary to designate the send (write) direction as either
up or down by #defining MSYNC_UP in the local process and MSYNC_DOWN
in the peer process (or vice versa).
The addresses of the synchronization bytes must be specified
with MSYNC_LOCL_ADDR or MSYNC_PEER_ADDR.

-----------------------------------------------------------------------------*/

#ifndef mbx_DEFINED
#define mbx_DEFINED

#define far

/* Function prototypes by default */
#ifdef __STDC__
#define _PARAMS(args) args
#else
#define _PARAMS(args) ()
#endif

/* Mailbox access macros */
#define mbx_get(i)		((unsigned char *)(MBX_BASE+(i+1) * MBX_LENGTH))

/* Values for parameter "writing" in msync_*() */
#define MBX_WRITING		1
#define MBX_READING		0

#define MSYNC_SHIFT(w) ((w) ? 4 : 0)

/* Address of local synchronization byte */
#ifdef MSYNC_LOCL_ADDR
#define MSYNC_LOCL (MSYNC_LOCL_ADDR)
#endif

/* Address of peer synchronization byte */
#ifdef MSYNC_PEER_ADDR
#define MSYNC_PEER (MSYNC_PEER_ADDR)
#endif

#endif /* mbx_DEFINED */
