#ifndef MARS_MCalibrationIntensityCam
#define MARS_MCalibrationIntensityCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef MARS_MArrayD
#include "MArrayD.h"
#endif

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class TOrdCollection;
class MCalibrationPix;
class MBadPixelsPix;
class MGeomCam;
class MCalibrationIntensityCam : public MParContainer, public MCamEvent
{
private:
  
  MArrayD fOffsets;           //! Arrays of Higain-vs-LoGain fit result Offsets
  MArrayD fSlopes;            //! Arrays of Higain-vs-LoGain fit result Slopes

protected:  

  TOrdCollection *fCams;        // Array of MCalibrationCams, one per pulse colour and intensity

  virtual void Add(const UInt_t from, const UInt_t to);
  virtual void InitSize( const UInt_t n );
  
public:

  MCalibrationIntensityCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationIntensityCam();
  
  void  Clear ( Option_t *o="" );
  void  Copy(TObject& object) const;  
  
  void AddToList( const char* name, const MGeomCam &geom );

  // Draws
  void DrawHiLoFits();
  void DrawPixelContent( Int_t num) const;
  
  // Getters
  Bool_t GetPixelContent( Double_t &val, Int_t idx, const MGeomCam &cam,Int_t type=0) const;
  const Int_t GetSize() const;

  const Int_t            GetAverageAreas     ()            const;	 
        MCalibrationPix &GetAverageArea      ( UInt_t i );
  const MCalibrationPix &GetAverageArea      ( UInt_t i )  const;
        MBadPixelsPix   &GetAverageBadArea   ( UInt_t i );
  const MBadPixelsPix   &GetAverageBadArea   ( UInt_t i )  const;
  const Int_t            GetAverageSectors   ()            const;
        MCalibrationPix &GetAverageSector    ( UInt_t i );
  const MCalibrationPix &GetAverageSector    ( UInt_t i )  const;
        MBadPixelsPix   &GetAverageBadSector ( UInt_t i );
  const MBadPixelsPix   &GetAverageBadSector ( UInt_t i )  const;

        MCalibrationCam *GetCam              ( Int_t i=-1);
  const MCalibrationCam *GetCam              ( Int_t i=-1) const;

        MCalibrationCam *GetCam              ( const char *name );
  const MCalibrationCam *GetCam              ( const char *name ) const;

        MCalibrationPix &operator[]          ( UInt_t i );
  const MCalibrationPix &operator[]          ( UInt_t i )  const;
 
  const Float_t GetNumHiGainFADCSlices ( const Int_t aidx=0 ) const { return GetCam()->GetNumHiGainFADCSlices(aidx); }
  const Float_t GetNumLoGainFADCSlices ( const Int_t aidx=0 ) const { return GetCam()->GetNumLoGainFADCSlices(aidx); }
  const Int_t   GetNumUnsuitable       ( const Int_t aidx=-1) const { return GetCam()->GetNumUnsuitable(aidx);       }
  const Int_t   GetNumUnreliable       ( const Int_t aidx=-1) const { return GetCam()->GetNumUnreliable(aidx);       }
  
  // Inits
  void  Init   ( const MGeomCam &geom );
  
  // Prints
  void   Print(Option_t *o="")         const;

  // Setters
  void  SetNumHiGainFADCSlices( const Float_t f, const Int_t aidx=0) { GetCam()->SetNumHiGainFADCSlices(f,aidx); }
  void  SetNumLoGainFADCSlices( const Float_t f, const Int_t aidx=0) { GetCam()->SetNumLoGainFADCSlices(f,aidx); }
  void  SetNumUnsuitable      ( const UInt_t i,  const Int_t aidx  ) { GetCam()->SetNumUnsuitable(i,aidx);       }
  void  SetNumUnreliable      ( const UInt_t i,  const Int_t aidx  ) { GetCam()->SetNumUnreliable(i,aidx);       }
  void  SetPulserColor        ( const MCalibrationCam::PulserColor_t col=MCalibrationCam::kCT1) {
                                                                GetCam()->SetPulserColor(col);            }

  ClassDef(MCalibrationIntensityCam, 1) // Base Container Intensity Calibration Results
};

#endif
