#ifndef MARS_MFSoftwareTrigger
#define MARS_MFSoftwareTrigger

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MMcEvt;
class MGeomCam;
class MCerPhotEvt;

class MFSoftwareTrigger : public MFilter
{
private:
    const MGeomCam    *fCam; // Camera Geometry
    const MCerPhotEvt *fEvt; // Cerenkov Photon Event

    Float_t     fNumMinPhotons; // nuber of minimum required photons
    Byte_t      fNumNeighbors;  // number of required neighbours

    Int_t       fCut[2];

    Bool_t      fResult;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    Bool_t SwTrigger() const;

    Bool_t IsExpressionTrue() const { return fResult; }

public:
    MFSoftwareTrigger(const char *name=NULL, const char *title=NULL);

    void SetNumMinPhotons(Float_t minphotons) { fNumMinPhotons = minphotons; }
    void SetNumNeighbors(Byte_t num) { fNumNeighbors = num; }

    ClassDef(MFSoftwareTrigger, 0) // Filter for software trigger
};

#endif
