#ifndef MARS_MHEffectiveOnTime
#define MARS_MHEffectiveOnTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TH2
#include <TH2.h>
#endif
#ifndef ROOT_TF1
#include <TF1.h>
#endif

class MTime;
class MPointingPos;
class MParameterDerr;

class MParList;

class MHEffectiveOnTime : public MH
{
private:
    MPointingPos   *fPointPos; //! Container to get the zenith angle from
    MTime           fLastTime; //! Time-Stamp of last event

    MTime          *fTime;     //! Time-Stamp of "effective on-time" event
    MParameterDerr *fParam;    //! Output container for effective on-time

    TH2D fH2DeltaT;      // Counts vs Delta T and Theta
    TH1D fH1DeltaT;      //! Counts vs Delta T (for a time interval)

    TH1D fHThetaEffOn;   // Effective On time versus Theta
    TH1D fHThetaProb;    // Chisq prob fit of Effective On time versus Theta
    TH1D fHThetaNDF;     // NDF vs Theta
    TH1D fHThetaLambda;  // Slope (rate) vs Theta

    TH1D fHTimeEffOn;    // Effective On time versus Time
    TH1D fHTimeProb;     // Chisq prob fit of Effective On time versus Time
    //TH1D fHTimeNDF;      // NDF vs Time
    TH1D fHTimeLambda;   // Slope (rate) vs Time

    Bool_t fIsFinalized; // Flag telling you whether fHThetaEffOn is the final result

    Int_t fNumEvents;    // Number of events to be used for a bin in time

    const TString fNameProjDeltaT; //! This should make sure, that gROOT doen't confuse the projection with something else
    const TString fNameProjTheta;  //! This should make sure, that gROOT doen't confuse the projection with something else

    Bool_t FitH(TH1D *h, Double_t *res, Bool_t paint=kFALSE) const;
    void FitThetaBins();
    void FitTimeBin();
    void PaintProb(TH1 &h) const;
    void PaintText(Double_t val, Double_t error) const;
    void PaintText(Double_t *res) const;
    void DrawRightAxis(const char *title);
    void UpdateRightAxis(TH1 &h);
    void PrintStatistics();

public:
    MHEffectiveOnTime(const char *name=NULL, const char *title=NULL);

    void SetNumEvents(Int_t i) { fNumEvents=i; }

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    const TH1D &GetHEffOnTheta() const { return fHThetaEffOn; }
    const TH1D &GetHEffOnTime() const { return fHTimeEffOn; }

    void Draw(Option_t *option="");
    void Paint(Option_t *opt="");

    ClassDef(MHEffectiveOnTime, 1) // Histogram to determin effective On-Time vs Time and Zenith Angle
};

#endif

