#ifndef MARS_MHSigmaPixel
#define MARS_MHSigmaPixel

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

class TH2D;

class MMcEvt;
class MParList;
class MPedestalCam;

class MHSigmaPixel : public MH
{
private:
    MPedestalCam *fPedestalCam; //!

    TH2D fHist;

public:
    MHSigmaPixel(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    const TH2D *GetHist()       { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");

    ClassDef(MHSigmaPixel, 1) //2D-histogram in Sigma and Pixel number
};

#endif





