#ifndef MARS_MStereoPar
#define MARS_MStereoPar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MHillas;
class MGeomCam;
class MMcEvt;

class MStereoPar : public MParContainer
{
private:

    Float_t fCoreX;
    Float_t fCoreY;   // Estimated core position on ground

    Float_t fCoreX2;  // Estimated core position on ground assuming 
    Float_t fCoreY2;  // that the source direction is paralel to the 
                      // telescope axis.

    Float_t fSourceX; // Estimated source position on the camera
    Float_t fSourceY; // Units are degrees! 

    Float_t fTheta2;  // deg^2; Squared angular distance of estimated
                      // source position to cameracenter.

    Float_t fCT1Impact; // Estimated shower impact parameter from CT1
    Float_t fCT2Impact; // Estimated shower impact parameter from CT2

    Float_t fCT1Impact2; // Estimated shower impact parameter from CT1
                         // assuming that the source direction is paralel 
                         // to the telescope axis.

    Float_t fCT2Impact2; // Estimated shower impact parameter from CT2
                         // assuming that the source direction is paralel 
                         // to the telescope axis.


    void Camera2direction(Float_t rc, Float_t CTphi, Float_t CTtheta, Float_t x, Float_t y, Float_t* cosx, Float_t* cosy, Float_t* cosz);


public:
    MStereoPar(const char *name=NULL, const char *title=NULL);

    void Reset();

    Float_t GetCoreX() const { return fCoreX; }
    Float_t GetCoreY() const { return fCoreY; }
    Float_t GetSourceX() const { return fSourceX; }
    Float_t GetSourceY() const { return fSourceY; }
    Float_t GetTheta2() const { return fTheta2; }
    Float_t GetCT1Impact() const { return fCT1Impact; }
    Float_t GetCT2Impact() const { return fCT2Impact; }
    Float_t GetCT1Impact2() const { return fCT1Impact2; }
    Float_t GetCT2Impact2() const { return fCT2Impact2; }


    void Calc(const MHillas &hillas1, const MMcEvt &mcevt1, const MGeomCam &mgeom1, const Float_t ct1_x, const Float_t ct1_y, const MHillas &hillas2, const MMcEvt &mcevt2, const MGeomCam &mgeom2, const Float_t ct2_x, const Float_t ct2_y);

    ClassDef(MStereoPar, 1) // Container to hold new image parameters
};

#endif



























