#ifndef MARS_MSrcPosCalc
#define MARS_MSrcPosCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MObservatory;
class MPointingPos;
class MSrcPosCam;
class MGeomCam;
class MTime;

class MSrcPosCalc : public MTask
{
private:
    MObservatory *fObservatory;
    MPointingPos *fPointPos;
    MSrcPosCam   *fSrcPos;
    MGeomCam     *fGeom;
    MTime        *fTime;

    Double_t fR;    // Distance of source to a fitted star
    Double_t fDrho; // angle between the two stars

    Double_t fX;    // [deg] x-position of source
    Double_t fY;    // [deg] y-position of source

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Bool_t ReInit(MParList *pList);

public:
    MSrcPosCalc(const char *name=NULL, const char *title=NULL);

    // Use is deprecated!
    void SetOffset(Double_t r, Double_t drho)
    {
        fDrho = drho*TMath::DegToRad();
        fR    = r;
    }
    void SetPositionXY(Double_t x, Double_t y) { fX=x; fY=y; }

    ClassDef(MSrcPosCalc, 0) // Derotates the source position in the camera
};

#endif
