#ifndef MARS_MSourceDirections
#define MARS_MSourceDirections

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MAstroCamera
#include "MAstroCamera.h"
#endif

class MTime;
class MReportDrive;
class MStarCam;
class MStarPos;

class MSourceDirections : public MTask
{

private:

    MGeomCam      *fGeomCam;
    MTime         *fTimeCurr;
    MReportDrive  *fDrive;
    MStarCam *fStars;

    MAstroCamera fAstro;
  
    TString fGeometryFile;

  public:
    
    MSourceDirections(const char *name=NULL, const char *title=NULL);
    
    Int_t AddDirection(Float_t ra, Float_t dec, Float_t mag, TString name="");
    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    // setters
    void SetGeometryFile(TString f) {fGeometryFile=f;}
    void SetRaDec(Double_t ra, Double_t dec) {fAstro.SetRaDec(ra,dec);}
    void SetRaDec(TVector3 &v) { fAstro.SetRaDec(v); }
    void SetRadiusFOV(Double_t deg) { fAstro.SetRadiusFOV(deg); }
    
  ClassDef(MSourceDirections, 0) // Tool to translate RaDec Source Directions into camera coordinates
};

#endif
