/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lpez, 05/2004 <mailto:jlopez@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}


void findstars(const TString filename="20040422_*_D_Mrk421_E.root", const TString directory="/local_disk/Data/rootdata/Mrk421/Period016/2004_04_22/", const UInt_t numEvents = 0)
{

  //
  // Create a empty Parameter List and an empty Task List
  // The tasklist is identified in the eventloop by its name
  //
  MParList  plist;
  
  MTaskList tlist;
  plist.AddToList(&tlist);


  MGeomCamMagic geomcam;
  MCameraDC     dccam;
  MStarLocalCam starcam;

  plist.AddToList(&geomcam);
  plist.AddToList(&dccam);
  plist.AddToList(&starcam);

  //
  // Now setup the tasks and tasklist:
  // ---------------------------------
  //

  // Reads the trees of the root file and the analysed branches
  MReadReports read;
  read.AddTree("Currents"); 
  read.AddFile(directory+filename);     // after the reading of the trees!!!
  read.AddToBranchList("MReportCurrents.*");

  MGeomApply geomapl;
  TString continuoslightfile = 
    "/local_disk/CaCoData/rootdata/Miscellaneous/Period016/2004_04_16/dc_2004_04_16_04_46_18_22368_Off3c279-2CL100.root";

  Float_t mindc = 0.9; //[uA]
  MCalibrateDC dccal;
  dccal.SetFileName(continuoslightfile);
  dccal.SetMinDCAllowed(mindc);

  const Int_t numblind = 5;
  const Short_t x[numblind] = { 47, 124, 470, 475, 571};
  const TArrayS blindpixels(numblind,(Short_t*)x);
  Float_t ringinterest = 100; //[mm]
  Float_t tailcut = 3.5;
  UInt_t integratedevents = 4;

  MFindStars findstars;
  findstars.SetBlindPixels(blindpixels);
  findstars.SetRingInterest(ringinterest);
  findstars.SetDCTailCut(tailcut);
  findstars.SetNumIntegratedEvents(integratedevents);
  findstars.SetMinuitPrintOutLevel(-1);

  
  tlist.AddToList(&geomapl);
  tlist.AddToList(&read);
  tlist.AddToList(&dccal);
  tlist.AddToList(&findstars, "Currents");

  //
  // Create and setup the eventloop
  //
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
     
  //
  // Execute your analysis
  //

  if (numEvents > 0)
  {
      if (!evtloop.Eventloop(numEvents))
	  return;
  }
  else
  {
      if (!evtloop.PreProcess())
	  return;
      
//        MHCamera display0(geomcam);
//        display0.SetPrettyPalette();
//        display0.Draw();
//        //       display0.SetCamContent(dccal.GetDisplay());
//        display0.SetCamContent(dccal.GetDCCalibrationFactor());
//        gPad->Modified();
//        gPad->Update();

//        // Remove the comments if you want to go through the file
//        // event-by-event:
//        if (!HandleInput())
//          break;

       MHCamera display(geomcam);
       display.SetPrettyPalette();
       display.Draw();
       gPad->cd(1);
       starcam.Draw();
      
       UInt_t numevents=0;
       
       while (tlist.Process())
         {
           numevents++;
           if (numevents%integratedevents==0)
             {
               //               display.SetCamContent(dccam);
               display.SetCamContent(findstars.GetDisplay());
               gPad->Modified();
               gPad->Update();
               starcam.Print("maxpossizechi");
               // Remove the comments if you want to go through the file
               // event-by-event:
               if (!HandleInput())
                 break;
             }
      } 

      evtloop.PostProcess();
  }

  tlist.PrintStatistics();

}


