#ifndef MARS_MExtractedSignalCam
#define MARS_MExtractedSignalCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;
class MExtractedSignalPix;

class MExtractedSignalCam : public MParContainer, public MCamEvent
{
private:
    TClonesArray *fArray; //-> FIXME: Change TClonesArray away from a pointer?

    Byte_t fFirstUsedSliceHiGain;
    Byte_t fFirstUsedSliceLoGain;

    Byte_t fLastUsedSliceHiGain;
    Byte_t fLastUsedSliceLoGain;

    Float_t fUsedWindowHiGain;
    Float_t fUsedWindowLoGain;
    
public:

    MExtractedSignalCam(const char *name=NULL, const char *title=NULL);
    ~MExtractedSignalCam();

    void Print(Option_t *o="") const;
    void Clear(Option_t *o="");
    void SetLogStream(MLog *lg);

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    Float_t GetNumUsedHiGainFADCSlices() const { return fUsedWindowHiGain; }
    Float_t GetNumUsedLoGainFADCSlices() const { return fUsedWindowLoGain; }

    Byte_t GetFirstUsedSliceHiGain() const    { return fFirstUsedSliceHiGain; }
    Byte_t GetFirstUsedSliceLoGain() const    { return fFirstUsedSliceLoGain; }

    Byte_t GetLastUsedSliceHiGain()  const    { return fLastUsedSliceHiGain; }
    Byte_t GetLastUsedSliceLoGain()  const    { return fLastUsedSliceLoGain; }

    void   SetUsedFADCSlices(Byte_t firsth, Byte_t lasth, Float_t winh,
                             Byte_t firstl, Byte_t lastl, Float_t winl)
    {
      fFirstUsedSliceHiGain    = firsth;
      fLastUsedSliceHiGain     = lasth;
      fUsedWindowHiGain        = winh;
      fFirstUsedSliceLoGain    = firstl;
      fLastUsedSliceLoGain     = lastl;
      fUsedWindowLoGain        = winl;
    }

    MExtractedSignalPix &operator[](Int_t i);
    const MExtractedSignalPix &operator[](Int_t i) const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MExtractedSignalCam, 1)	// Storage Container for extracted signals in the camera
};

#endif

