/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */


void resize()
{
  MParList plist;
  MTaskList tlist;

  plist.AddToList(&tlist);

  MReadMarsFile  read("Events", "star_gamma_train.root");

  read.DisableAutoScheme();
  tlist.AddToList(&read);

  MWriteRootFile write("star_gamma_train_new.root", "recreate");

  write.AddContainer("MMcEvt",         "Events");
  write.AddContainer("MHillas",        "Events");
  write.AddContainer("MHillasExt",     "Events");
  write.AddContainer("MImagePar",      "Events");
  write.AddContainer("MNewImagePar",   "Events");
  write.AddContainer("MHillasSrc",     "Events");

  write.AddContainer("MGeomCam", "RunHeaders");
  write.AddContainer("MMcConfigRunHeader", "RunHeaders");
  write.AddContainer("MMcCorsikaRunHeader", "RunHeaders");
  write.AddContainer("MMcFadcHeader", "RunHeaders");
  write.AddContainer("MMcTrigHeader", "RunHeaders");

  write.AddContainer("MRawRunHeader", "RunHeaders");
  write.AddContainer("MSrcPosCam",    "RunHeaders");
  write.AddContainer("MMcRunHeader",  "RunHeaders");


  //
  // Histogram: event acceptance probability vs log10(Size). Binning
  // and range are completely free. Beyond the histogram limits all 
  // events are accepted
  //

  TH1F* h = new TH1F("h", "", 20, 2., 4.);

  Float_t frac[20] = {0.144928, 0.171911, 0.18763, 0.209461, 0.253219, 
		      0.305425, 0.384593, 0.485204, 0.612452, 0.708138, 
		      0.754522, 0.728028, 0.774046, 0.791422, 0.808775, 
		      0.896842, 1., 1., 1., 1.};
 
  for (Int_t i = 0; i < 20; i++)
    h->SetBinContent(i+1, frac[i]);

  MFSize fsize;
  fsize.SetProb(h);

  write.SetFilter(&fsize);

  tlist.AddToList(&fsize);
  tlist.AddToList(&write);

  MEvtLoop evtloop;
  evtloop.SetParList(&plist);

  MProgressBar *bar = new MProgressBar;
  evtloop.SetProgressBar(bar);

  //
  // Execute your analysis
  //
  if (!evtloop.Eventloop())
    return;

  tlist.PrintStatistics();

  bar->DestroyWindow();

  return;
}
