#ifndef MARS_MImagePar
#define MARS_MImagePar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MHillas;
class MGeomCam;
class MCerPhotEvt;

class MImagePar : public MParContainer
{
private:
    Short_t fNumIslands;     // Number of islands found

    Short_t fNumSatPixelsHG; // number of pixels with saturating hi-gains
    Short_t fNumSatPixelsLG; // number of pixels with saturating lo-gains

public:
    MImagePar(const char *name=NULL, const char *title=NULL);

    void Reset();

    Short_t GetNumIslands() const { return fNumIslands; }

    Short_t GetNumSatPixelsHG() const { return fNumSatPixelsHG; }
    Short_t GetNumSatPixelsLG() const { return fNumSatPixelsLG; }

    void Print(Option_t *opt=NULL) const;

    void Calc(const MCerPhotEvt &evt);

    ClassDef(MImagePar, 1) // Container to hold (geometry and island independant) image parameters
};

#endif
