#ifndef MARS_MMuonCalibPar
#define MARS_MMuonCalibPar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MCerPhotEvt;
class MMuonSearchPar;

class MMuonCalibPar : public MParContainer
{
private:
  Float_t fArcLength;     // An arc length of a muon along the arc [deg.]
  Float_t fArcPhi;        // A opening angle of a muon arc [deg.]
  Float_t fArcWidth;      // A width of a muon [deg.] (1 sigma of gaussian fit)
  Float_t fChiArcPhi;     // A chisquare value of the cosine fit for arc phi
  Float_t fChiArcWidth;   // A chisquare value of the cosine fit for arc wid
  Float_t fMuonSize;      // A SIZE of muon which is defined as a SIZE around the estimated circle
  Float_t fEstImpact;     // An estimated impact parameter from the photon distribution along the arc image
  Float_t fMargin;        // margin to evaluate muons [mm]. The defaut value is 60 mm, corresponding to 0.2 deg. This value can be changed by using the function of SetMargin
  Bool_t  fUseUnmap;      // This is a flag to know the Unmapped pixels are used. Refer to the class of MImgCleanStd
  Float_t fPeakPhi;       // The angle which indicates the peak position in the estimated circle
  Float_t fArcPhiThres;   // The threshold value to define arc phi
  Float_t fArcWidthThres; // The threshold value to define arc width

public:
  MMuonCalibPar(const char *name=NULL, const char *title=NULL);
  ~MMuonCalibPar();
  
  Int_t   fArcPhiBinNum;         // The bin number for the histogram of arc phi. You may change this value. However, if you change this, YOU ALSO HAVE TO CHANGE THE THRESHOLD VALUE TO GET ARC LENGTH.
  Int_t   fArcWidthBinNum;       // The bin number for the histogram of arc wid
  Float_t fArcPhiHistStartVal;   // The starting value for the histogram of arc phi
  Float_t fArcPhiHistEndVal;     // The end value for the histogram of arc phi
  Float_t fArcWidthHistStartVal; // The starting value for the histogram of arc width
  Float_t fArcWidthHistEndVal;   // The end value for the histogram of arc width

  TH1F *fHistPhi;   // Histogram of photon distribution along the arc.
  TH1F *fHistWidth; // Histogram of radial photon distribution of the arc.
  
  void Reset();
  
  Float_t GetArcLength()      const { return fArcLength; }
  Float_t GetArcPhi()         const { return fArcPhi; }
  Float_t GetArcWidth()       const { return fArcWidth; }
  Float_t GetChiArcPhi()      const { return fChiArcPhi; }
  Float_t GetChiArcWidth()    const { return fChiArcWidth; }
  Float_t GetMargin()         const { return fMargin; }
  Float_t GetMuonSize()       const { return fMuonSize; }
  Float_t GetEstImpact()      const { return fEstImpact; }
  Bool_t  IsUseUnmap()        const { return fUseUnmap; }
  Float_t GetPeakPhi()        const { return fPeakPhi; }
  Float_t GetArcPhiThres()    const { return fArcPhiThres; }
  Float_t GetArcWidthThres()  const { return fArcWidthThres; }
  Float_t GetArcPhiBinNum()   const { return fArcPhiBinNum; }
  Float_t GetArcWidthBinNum() const { return fArcWidthBinNum; }
  TH1F    *GetHistPhi()       { return fHistPhi; }
  TH1F    *GetHistWidth()     { return fHistWidth; }
  
  void    SetArcLength(Float_t len)       { fArcLength = len; }
  void    SetArcPhi(Float_t phi)          { fArcPhi = phi; }
  void    SetArcWidth(Float_t wid)        { fArcWidth = wid; }
  void    SetChiArcPhi(Float_t chi)       { fChiArcPhi = chi; }
  void    SetChiArcWidth(Float_t chi)     { fChiArcWidth = chi; }
  void    SetMargin(Float_t margin)       { fMargin = margin; }
  void    SetMuonSize(Float_t size)       { fMuonSize = size; }
  void    SetEstImpact(Float_t impact)    { fEstImpact = impact; }
  void    SetUseUnmap()                   { fUseUnmap = kTRUE; }
  void    SetPeakPhi(Float_t phi)         { fPeakPhi = phi; }
  void    SetArcPhiThres(Float_t thres)   { fArcPhiThres = thres; }
  void    SetArcWidthThres(Float_t thres) { fArcWidthThres = thres; }
  void    SetArcPhiBinNum(Int_t num)      { fArcPhiBinNum = num; }
  void    SetArcWidthBinNum(Int_t num)    { fArcWidthBinNum = num; }
  
  void    Print(Option_t *opt=NULL) const;

  ClassDef(MMuonCalibPar, 1) // Container to hold muon calibration parameters
};
    
#endif
