#ifndef MARS_MSupercutsCalcONOFF
#define MARS_MSupercutsCalcONOFF

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MParList;
class MHillas;
class MHillasSrc;
class MHillasExt;
class MNewImagePar;
class MPointingPos;
class MCerPhotEvt;
class MGeomCam;
class MHadronness;
class MHMatrix;
class MSupercuts;
class MTSupercutsApplied;

class MSupercutsCalcONOFF : public MTask
{
private:
    MHillas       *fHil;
    MHillasSrc    *fHilSrc;
    MHillasExt    *fHilExt;
    MNewImagePar  *fNewPar;
    MPointingPos  *fPointPos;
    MHadronness   *fHadronness; //! output container for hadronness
    MTSupercutsApplied *fSupercutsApplied; // output container for applied supercuts
    MSupercuts *fSuper;      // container for supercut parameters

    TString  fHadronnessName;   // name of container to store hadronness
    TString  fSupercutsAppliedName;        // name of the container to store applied supercuts
    TString  fHilName;
    TString  fHilSrcName;
    TString  fHilExtName;
    TString  fNewParName;
    TString  fSuperName;        // name of container for supercut parameters

    Double_t fMm2Deg;           //!

    Int_t     fMap[11];         //!
    MHMatrix *fMatrix;          //!

    Bool_t fStoreAppliedSupercuts; // Boolean variable used to decided wether to store (kTRUE) or not (kFALSE) the supercuts applied


    // Boolean variable used to control decide wether to use theta information 
    // in the computation of teh dynamical cuts.
    Bool_t fNotUseTheta;

    // Boolean variable used to decide wether to use dynamical cuts or static cuts
    // kTRUE means that static cuts are used
    Bool_t fUseStaticCuts;


    // Boolean variable that allows to use/not use the dist info in the cuts parameterization
    // kTRUE for use it.
    // For the time being this variable is set in the constructor

    Bool_t fUseDist;



     // OFFSETS FOR THE DYNAMICAL CUTS
    // Values of Size (photons), Dist (degrees) and Theta (degrees) 
    // for which the value of the dynamical cut is equal to the 
    // non dependent parameter; i.e. to the static cut. 
    // By adjusting these offsets the user can set the value in size, 
    // dist and theta for which the dynamical cuts will be given by 
    // the term that DOES not depend on size, dist and theta.

    // For the time being, these quantities are set in the constructor. 
    // In future, if they show to be useful, I will make them available 
    // as external variables.

    Double_t fSizeOffset; // photons
    Double_t fDistOffset; // degrees   NOT USED FOR THE TIME BEING
    Double_t fThetaOffset; // degrees   NOT USED FOR THE TIME BEING




    // Variables defining upper/lower limits for some of the hillas params
    // Variables in degrees !!

    Double_t fDistUpperLimit;
    Double_t fLengthUpperLimit;
    Double_t fWidthUpperLimit;

     Double_t fDistLowerLimit;
    Double_t fLengthLowerLimit;
    Double_t fWidthLowerLimit;

    // tmp

    Double_t fLeakage1UpperLimit;

    Double_t fLengthOverWidthUpperLimit;
    
    //endtemp

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    Double_t GetVal(Int_t i) const;

    Double_t CtsMCut(const Double_t* a, Double_t ls, Double_t ct,
                     Double_t ls2, Double_t dd2) const;
    /*
    Bool_t StoreSupercutsAppliedToThisEvent(Double_t lengthup, Double_t lengthlow, 
					    Double_t widthup, Double_t widthlow, 
					    Double_t distup, Double_t distlow);
    */     
public:
    MSupercutsCalcONOFF(const char *hilname="MHillas",
                      const char *hilsrcname="MHillasSrc",
                      const char *name=NULL, const char *title=NULL);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    TString GetHadronnessName() const { return fHadronnessName; }

    void SetSupercutsAppliedName(const TString name) { fSupercutsAppliedName = name; }
    TString GetSupercutsAppliedName() const { return fSupercutsAppliedName; }


    void SetStoreAppliedSupercuts(Bool_t b);
    Bool_t GetStoreAppliedSupercuts() {return fStoreAppliedSupercuts;}


    void SetVariableNotUseTheta(Bool_t b);
    Bool_t GetVariableNotUseTheta() { return fNotUseTheta;}

    void SetVariableUseStaticCuts(Bool_t b);
    Bool_t GetVariableUseStaticCuts() { return fUseStaticCuts;}


    
    void SetHillasDistLengthWidthUpperLowerLimits(Double_t distup, 
						  Double_t lengthup, 
						  Double_t widthup, 
						  Double_t distlow, 
						  Double_t lengthlow, 
						  Double_t widthlow);

    void InitMapping(MHMatrix *mat); // use quantity ThetaOrig.fVal at theta
    
    void StopMapping() { InitMapping(NULL); }

    


    ClassDef(MSupercutsCalcONOFF, 0) // A class to evaluate the Supercuts
};

#endif












