#ifndef MARS_MBadPixelsCam
#define MARS_MBadPixelsCam

#ifndef MARS_MBadPixelsPix
#include "MBadPixelsPix.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MGeomPix;
class TClonesArray;

class MBadPixelsCam : public MParContainer, public MCamEvent
{
private:
    TClonesArray *fArray; //-> 

    Short_t GetNumSuitableNeighbors(MBadPixelsPix::UnsuitableType_t type, const MGeomPix &pix) const;
    Short_t GetNumMaxCluster(MBadPixelsPix::UnsuitableType_t type, TObjArray &list, Int_t idx, Int_t aidx) const;

public:
    MBadPixelsCam(const char *name=NULL, const char *title=NULL);
    MBadPixelsCam(const MBadPixelsCam &cam);
    ~MBadPixelsCam();

    void Reset();
    void Clear(Option_t *o="");
    void Print(Option_t *o="") const;
    void Copy(TObject &object) const;

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    MBadPixelsPix &operator[](Int_t i);
    const MBadPixelsPix &operator[](Int_t i) const;

    void Merge(const MBadPixelsCam &cam);

    Short_t GetNumUnsuitable(MBadPixelsPix::UnsuitableType_t type, const MGeomCam *geom, Int_t aidx=-1) const;
    Short_t GetNumUnsuitable(MBadPixelsPix::UnsuitableType_t type) const { return GetNumUnsuitable(type, 0); }
    Short_t GetNumIsolated(MBadPixelsPix::UnsuitableType_t type, const MGeomCam &geom, Int_t aidx=-1) const;
    Short_t GetNumIsolated(const MGeomCam &geom, Int_t aidx=-1) const { return GetNumIsolated(MBadPixelsPix::kUnsuitableRun, geom, aidx); }
    Short_t GetNumMaxCluster(MBadPixelsPix::UnsuitableType_t type, const MGeomCam &geom, Int_t aidx=-1) const;
    Short_t GetNumMaxCluster(const MGeomCam &geom, Int_t aidx=-1) { return GetNumMaxCluster(MBadPixelsPix::kUnsuitableRun, geom, aidx); }

    void   AsciiRead(istream &fin, UInt_t run);
    void   AsciiRead(istream &fin) { AsciiRead(fin, 0); }
    Bool_t AsciiWrite(ostream &out, UInt_t run) const;
    Bool_t AsciiWrite(ostream &out) const { return AsciiWrite(out, 0); }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MBadPixelsCam, 1)	//Storage container to store bad pixel of the camera...
};

#endif

