#ifndef SAOFILE_H
#define SAOFILE_H

#include <TROOT.h>

#include "coord.h"

struct _sort
{
   int ra;
   int dec;
   int nr;
};

typedef struct _sort sort_t;

class File;

class SaoFile
{
private:
    File *file;
    int compressed;

    char data[205];

    int   SAO;
    char  delFlag;
    float Pmag;
    float Vmag;
    // int   RA2000h;
    // int   RA2000m;
    // float RA2000s;
    float pmRA2000;
    // char  DE2000sgn;
    // int   DE2000d;
    // int   DE2000m;
    float DE2000s;
    float pmDE2000;
    float RA2000rad;
    float DE2000rad;

    int fEntries;

public:
    SaoFile(const char *name);
    virtual ~SaoFile();

    void  Compress();
    void  Sort();

    int   GetEntryNr() const;
    int   GetEntry(const int i);
    void  Reset() const;
    int   GetNextEntry();
    void  Print() const;

    int   GetNrOfEntries() const { return fEntries; }

    int   Nr() const          { return SAO; }
    int   DelFlag() const     { return delFlag=='D'; }
    float MagP() const        { return Pmag; }
    float MagV() const        { return Vmag; }
    float Ra() const          { return RA2000rad; }
    float Dec() const         { return DE2000rad; }
    RaDec GetRaDec() const    { return RaDec(RA2000rad, DE2000rad); }

    float RaPm() const        { return pmRA2000; }
    float DecPm() const       { return pmDE2000; }
    RaDec GetRaDecPm() const  { return RaDec(pmRA2000, pmDE2000); }


    // char DecSgn()   { return DE2000sgn; }
    // int   RaH()     { return RA2000h; }
    // int   DecD()    { return DE2000d; }
    // int   RaM()     { return RA2000m; }
    // int   DecM()    { return DE2000m; }
    // float RaS()     { return RA2000s; }
    // float DecS()    { return DE2000s; }

    const char *String() const { return data; }

    ClassDef(SaoFile, 0)
};

#endif
