#ifndef MARS_MSkyCamTrans
#define MARS_MSkyCamTrans

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MSkyCamTrans : public MParContainer
{
private:

    //Parameters of transformation from sky to camera
    
    Double_t fLambda;         // scale factor lambda
    Double_t fAlfa;           // rotation angle alfa [degrees]
    Double_t fA[2][2];        // rotation matrix A
    Double_t fD[2];           // shift D [mm]
    Double_t fErrD[2][2];     // error matrix of shift D   [mm*mm]

    Int_t    fNStars;
    Int_t    fNumIter;
    Int_t    fNdof;
    Double_t fChiSquare;
    Double_t fChiSquareProb;

public:

    MSkyCamTrans(const char *name=NULL, const char *title=NULL);

    void SetParameters(Double_t &,       Double_t &,
		       Double_t[2][2],   Double_t[2], Double_t[2][2], 
              Int_t &, Int_t &, Int_t &, Double_t &,  Double_t &);
 
    Int_t    GetNStars()             { return fNStars;       }
    Int_t    GetNumIter()            { return fNumIter;       }
    Int_t    GetNdof()               { return fNdof;          }
    Double_t GetChiSquare()          { return fChiSquare;     }
    Double_t GetChiSquareProb()      { return fChiSquareProb; }
    Double_t GetLambda()             { return fLambda;        }
    Double_t GetAlfa()               { return fAlfa;          }

    Double_t *GetRotationMatrix()    { return &fA[0][0];      }  
    Double_t *GetShiftD()            { return &fD[0];         }  
    Double_t *GetErrMatrixShiftD()   { return &fErrD[0][0];   }  

    ClassDef(MSkyCamTrans, 1) // Container holding the sky-camera transformation parameters
};

#endif






