/***************************************************************************
                          amccmdstate.h  -  description
                             -------------------
    begin                : Tue Jul 27 2004
    copyright            : (C) 2004 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMCCMDSTATE_H
#define AMCCMDSTATE_H

#include <qobject.h>
#include <qstring.h>
#include <qdatetime.h>

/** State of the last command received by the AMC.
 * @author Martin Merck
 */

#define AMC_CMD_STATE_NOCMD						0
#define AMC_CMD_STATE_ACKNOWLEDGED		1
#define AMC_CMD_STATE_NOTACKNOWLEDGED	2
#define AMC_CMD_STATE_ABORTED					3
#define AMC_CMD_STATE_COMPLETED				4
#define AMC_CMD_STATE_INVALID					5
#define AMC_CMD_STATE_UNKNOWN					6

class AMCCmdState : public QObject  {
   Q_OBJECT

public:
	AMCCmdState( QObject *parent=0, const char *name=0 );
	~AMCCmdState();

  /** Return the actual state. */
  int getState() const;
  /** Set the state. */
  void setState( int p_iState );
  /** Get a textual description of the state. */
  const QString& getText( int p_iState ) const;
  /** Get a textual description of the last command received from CC. */
  const QString& getCmd() const { return m_qsLastCmd;}
  /** Get a textual description of the state. */
  void setCmd( QString p_qsCmd, QDateTime p_gdtTime ) { m_qsLastCmd = p_qsCmd; m_gdtTimestamp = p_gdtTime; }

private: // Private attributes
  /** Variable holding the actual state. */
  int m_iState;
  /** Variable holding the Lid state. */
  int m_iStateLid;
  /**  */
  QDateTime m_gdtTimestamp;
  /**  */
  QString m_qsLastCmd;
  /**  */
  QString* m_qsCmdStateTxtTable[AMC_CMD_STATE_UNKNOWN+1];

signals: // Signals
  /** Signal emitted when the state changes. */
  void stateChanged( int p_iOldState, int p_iNewState );
};

#endif
