#ifndef MARS_MPedCalcFromLoGain
#define MARS_MPedCalcFromLoGain

#ifndef MARS_MExtractPedestal
#include "MExtractPedestal.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_MArrayB
#include "MArrayB.h"
#endif

class MRawEvtPixelIter;
class MPedestalPix;

class MPedCalcFromLoGain : public MExtractPedestal
{
private:
    static const UShort_t fgCheckWinFirst;    // First FADC slice to check for signal (currently set to: 0)
    static const UShort_t fgCheckWinLast;     // Last FADC slice to check for signal  (currently set to: 29)
    static const UShort_t fgMaxSignalVar;     // The maximum difference between the highest and lowest slice
    static const UShort_t fgExtractWinFirst;  // First FADC slice to use for pedestal calculation (currently set to: 15)
    static const UShort_t fgExtractWinSize;   // number of successive slices used to calculate pedestal (currently set to: 6)

    UShort_t fMaxSignalVar;
    UShort_t fCheckWinFirst;
    UShort_t fCheckWinLast;

    TArrayI fNumEventsUsed;      //! Number of events used for pedestal calc for each pixel
    TArrayI fTotalCounter;       //! Counter for dumping values to Pedestal Container

    MArrayB fSlices;             //! workaround to put hi- and lo-gain slices together

    Bool_t ReInit(MParList *pList);
    Int_t  Process();
    Int_t  PostProcess();

    Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    //Helper function to extract slice values by slice number
    void CalcExtractor(const MRawEvtPixelIter &pixel, Float_t &sum, MPedestalPix &ped);
    void ResetArrays();

    void CalcSectorResult();
    void CalcAreaResult();

public:

    MPedCalcFromLoGain(const char *name=NULL, const char *title=NULL);

    void Print(Option_t *o="") const;

    // Setters
    Bool_t SetCheckRange(UShort_t checkfirst=fgCheckWinFirst, UShort_t checklast=fgCheckWinLast);
    void SetMaxSignalVar(UShort_t maxvar=40)       { fMaxSignalVar = maxvar;    }

    // Getters
    TArrayI *GetNumEventsUsed() { return &fNumEventsUsed; }

    ClassDef(MPedCalcFromLoGain, 1)   // Task to calculate pedestals from data runs
};

#endif
