#ifndef MARS_MDispCalc
#define MARS_MDispCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MSrcPosCam
#include "MSrcPosCam.h"
#endif

class MHillas;
class MHillasSrc;
class MDisp;
class MSrcPosCam;

class MDispCalc : public MTask
{
private:

    MHillas    *fHillas;     //! Pointer to the source independent hillas parameters
    MHillasSrc *fHillasSrc;  //! Pointer to the source dependent hillas parameters
    MSrcPosCam *fSrcPos;     //! Pointer to the source position
    MDisp *fDisp; 

    Float_t fPsi;                 // [mm]  Psi Disp parameter (has to fixed before Disp calculations,
                                  //                      used for fPosDisp1, fPosDisp2, fDisp determination)
    
    Int_t       fErrors;

    Int_t PreProcess(MParList *plist);
    Int_t Process();
    Int_t PostProcess();

public:

    MDispCalc(const char *name=NULL, const char *title=NULL);
    
    void SetSrcPos(Float_t xpos, Float_t ypos) {fSrcPos->SetXY(xpos,ypos);}
    void SetPsi(Float_t psi) {fPsi = psi;}

    ClassDef(MDispCalc, 0) // task to calculate the Disp parameter and related positions
};

#endif
