#ifndef MARS_MHSigmaTheta
#define MARS_MHSigmaTheta

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

#ifndef ROOT_TH3
#include <TH3.h>
#endif


class MParList;
class MGeomCam;
class MCerPhotEvt;
class MPointingPos;
class MPedPhotCam;
class MBadPixelsCam;


class MHSigmaTheta : public MH
{
private:
    const MGeomCam *fCam;        //!
    MPedPhotCam    *fPed;        //!
    MCerPhotEvt    *fEvt;        //!
    MPointingPos   *fPointPos;   //!
    MBadPixelsCam  *fBad;        //!

    TString  fNamePedPhotCam; //! name of the 'MPedPhotCam' container

                           // sigmabar is the average pedestal sigma  
    TH2D *fSigmaTheta;      // 2D-distribution sigmabar versus Theta (Inner) 
    TH2D *fSigmaThetaOuter; // 2D-distribution sigmabar versus Theta (Outer) 

    TH3D *fSigmaPixTheta; // 3D-distr.:Theta, pixel, pedestal sigma
    TH3D *fDiffPixTheta;  // 3D-distr.:Theta, pixel, sigma^2-sigmabar^2

    TH2D *fThetaPhi;      // 2D-distribution Theta versus Phi 

    MBinning *fBinsPhi;            //!
    MBinning *fBinsTheta;          //!
    MBinning *fBinsSigma;          //!
    MBinning *fBinsSigmabarIn;     //!
    MBinning *fBinsSigmabarOut;    //!
    MBinning *fBinsPix;            //!
    MBinning *fBinsDiff;           //!

    void Paint(Option_t *opt="");

public:
    MHSigmaTheta(const char *name=NULL, const char *title=NULL);
    ~MHSigmaTheta();

    void SetNamePedPhotCam(const char *name)  { fNamePedPhotCam = name; }

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    const TH2D *GetThetaPhi() { return fThetaPhi; }
    const TH2D *GetThetaPhi() const { return fThetaPhi; }

    const TH2D *GetSigmaTheta() { return fSigmaTheta; }
    const TH2D *GetSigmaTheta() const { return fSigmaTheta; }

    const TH2D *GetSigmaThetaOuter() { return fSigmaThetaOuter; }
    const TH2D *GetSigmaThetaOuter() const { return fSigmaThetaOuter; }

    const TH3D *GetSigmaPixTheta() { return fSigmaPixTheta; }
    const TH3D *GetSigmaPixTheta() const { return fSigmaPixTheta; }

    const TH3D *GetDiffPixTheta() { return fDiffPixTheta; }
    const TH3D *GetDiffPixTheta() const { return fDiffPixTheta; }

    void Draw(Option_t *option="");

    ClassDef(MHSigmaTheta, 1) //2D-histogram  sigmabar vs. Theta
};

#endif





