/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Alessio Piccioli, 04/2004 <mailto:alessio.piccioli@pi.infn.it>
!   Author(s): Antonio Stamerra, 04/2004 <mailto:antonio.stamerra@pi.infn.it>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////////
//
// first_ana.C
// =============
//
//  This macro produces a ON/OFF plot using the alpha HillasSrc branch
//  taken from an analysis file produced by the AnalisiHillas.C macro
//  The significance of excess events is also computed (simple calculation,
//   no Li-Ma)
//
///////////////////////////////////////////////////////////////////////////


Float_t degTomm ( Float_t deg ) {
  return deg / 57.29577951 * 17000 ;
}

Int_t first_ana ( Char_t *fNameOn = "crab.root" , Char_t *fNameOff = "offcrab.root" , Float_t minsize = 1000 , Float_t minWdeg = 0.00 , Float_t maxWdeg = 0.125 , Float_t minLdeg = 0.0 , Float_t maxLdeg = 0.26 , Float_t minDdeg = 0.2 , Float_t maxDdeg = 0.8 ) {

  TFile *fileOn = new TFile ( fNameOn , "READ" ) ;
  TFile *fileOff = new TFile ( fNameOff , "READ" ) ;

  TTree *treeOn = (TTree *) fileOn -> Get ( "Parameters" ) ;
  TTree *treeOff = (TTree *) fileOff -> Get ( "Parameters" ) ;

  TString title ;

  title = "Abs(Alpha) plot ON-Source" ;
  TH1D *absalphaOn = new TH1D ( "absalphaOn" , title , 9 , 0 , 90 ) ;

  title = "Abs(Alpha) plot ON-Source" ;
  TH1D *absalphaOff = new TH1D ( "absalphaOff" , title , 9 , 0 , 90 ) ;

  TString scut ;
  scut = "MHillas.fSize>" ;
  scut += minsize ;
  cout << "CUT ON SIZE: " << scut << endl ;
  TCut Scut = scut ; 

  scut = "" ;
  scut += degTomm(minWdeg) ;
  scut += " < MHillas.fWidth && MHillas.fWidth < " ;
  scut += degTomm(maxWdeg) ;
  cout << "CUT ON WIDTH: " << scut << endl ;
  TCut Wcut = scut ; 

  scut = "" ;
  scut += degTomm(minLdeg) ;
  scut += " < MHillas.fLength && MHillas.fLength < " ;
  scut += degTomm(maxLdeg) ;
  cout << "CUT ON LENGTH: " << scut << endl ;
  TCut Lcut = scut ; 

  scut = "" ;
  scut += degTomm(minDdeg) ;
  scut += " < MHillasSrc.fDist && MHillasSrc.fDist < " ;
  scut += degTomm(maxDdeg) ;
  cout << "CUT ON DIST: " << scut << endl ;
  TCut Dcut = scut ; 

  treeOn -> Draw ( "abs(MHillasSrc.fAlpha)>>absalphaOn" , Scut && Wcut && Lcut && Dcut ) ; 
  treeOff -> Draw ( "abs(MHillasSrc.fAlpha)>>absalphaOff" , Scut && Wcut && Lcut && Dcut ) ;
  Double_t alpha = absalphaOn -> Integral ( 4 , 9 ) / absalphaOff -> Integral ( 4 , 9 ) ;
  Double_t evoff = absalphaOff -> Integral ( 1 , 3 ) ;

  absalphaOff -> Scale ( alpha ) ;

  Double_t fakeMax = absalphaOn -> GetMaximum ( ) ;
  fakeMax *= 1.1 ;

  Double_t fakeMin = absalphaOn -> GetMinimum ( ) ;
  fakeMin *= 0.8 ;

  TH2D *fake = new TH2D ( "fake" , "Mrk421 Sample B (ON/OFF) 15/02/2004" , 100 , 0 , 90 , 100 , fakeMin , fakeMax ) ;
  fake -> GetXaxis ( ) -> SetTitle ( "Parameter Alpha (deg)" ) ;
  fake -> GetYaxis ( ) -> SetTitle ( "NUmber of Events" ) ;
  fake -> GetYaxis ( ) -> SetTitleOffset ( 1.3 ) ;
  fake -> SetStats ( 0 ) ;

  TCanvas *c = new TCanvas ( "c" , "Alpha Canvas" , 800 , 600 ) ;
  c -> SetGridx ( ) ;
  c -> SetGridy ( ) ;
  
  absalphaOn -> SetMarkerStyle ( 22 ) ;
  absalphaOn -> SetMarkerSize ( 2.7 ) ;
  absalphaOff -> SetFillStyle ( 1001 ) ;
  absalphaOff -> SetFillColor ( 3 ) ;

  fake -> Draw ( ) ;
  absalphaOff -> Draw ( "SAME" ) ;
  absalphaOn -> Draw ( "SAMEE1" ) ;

  Double_t evon = absalphaOn -> Integral ( 1 , 3 ) ;

  cout << endl << "EntriesON:" << absalphaOn -> GetEntries ( ) ;
  cout << endl << "EntriesOFF:" << absalphaOff -> GetEntries ( ) ;
  cout << endl << "ON:" << evon << " OFF:" << evoff << " EXCESS:" << evon-evoff*alpha << " SIGMA:" << (evon-evoff*alpha)/TMath::Sqrt(evoff)/alpha << endl << endl ;
  
}

