#ifndef STARG_MStargHistograms
#define STARG_MStargHistograms

#include <TFile.h>

class TTree;
class MTime;
class ZdAz;
class Ring;
class Led;
class Leds;
class MStarList;
class ZdAz;

class MStargHistograms
{
private:
    TFile*         fFile;
    Double_t       fEvtTime;
    Double_t       fZenithDist;
    Double_t       fAzimuth;
    Double_t       fNomZd;
    Double_t       fNomAz;
    Double_t       fdZd;
    Double_t       fdAz;
    Double_t       fOffsetX;
    Double_t       fOffsetY;
    Double_t       fCenterX;
    Double_t       fCenterY;
    Double_t       fStars;
    Double_t       fSpots;
    Double_t       fBright;
    Double_t       fCenterZd;
    Double_t       fCenterAz;
    Double_t       fStarZd;
    Double_t       fStarAz;


public:
    MStargHistograms() : fFile(NULL)
    {
  
    }

    ~MStargHistograms()
    {
    
    }

    void Fill(Leds &spots, MStarList &stars, ZdAz &d, ZdAz sao, 
	      Ring &center, ZdAz &centerzdaz, ZdAz &star, Double_t bright,
	      const ZdAz &pos, const MTime &t);
    
    void OpenFile();
    void CloseFile();

    void InitHistograms();
    void DeleteHistograms();
    void ShowHistograms();
    void ResetHistograms();

};

#endif
