#ifndef MARS_MMuonCalibParCalc
#define MARS_MMuonCalibParCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMuonSearchPar;
class MMuonCalibPar;
class MSrcPosCam;
class MGeomCam;
class MCerPhotEvt;

class MMuonCalibParCalc : public MTask
{
private:
    MGeomCam       *fGeomCam;
    MCerPhotEvt    *fCerPhotEvt;
    MMuonCalibPar  *fMuonCalibPar;  
    MMuonSearchPar *fMuonSearchPar; 

    Float_t fMargin;           // margin to evaluate muons [mm]. The defaut value is 60 mm, corresponding to 0.2 deg. This value can be changed by using the function of SetMargin
    Float_t fArcPhiThres;     // The threshold value to define arc phi
    Float_t fArcWidthThres;   // The threshold value to define arc width
    Bool_t fEnableImpactCalc; // If true, the impact calculation will be done, which consumes a lot of time.
    Bool_t fDisablePreCuts;   // If true, the pre cuts to select muons for the calibration will be disabled.

    Float_t fPreCuts[5];  // The values for pre cuts.

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    TString fNameCerPhot;

public:
    MMuonCalibParCalc(const char *name=NULL, const char *title=NULL);

    void SetMargin(Float_t margin)       { fMargin = margin; }
    void SetArcPhiThres(Float_t thres)   { fArcPhiThres = thres; }
    void SetArcWidthThres(Float_t thres) { fArcWidthThres = thres; }
    void EnableImpactCalc()              { fEnableImpactCalc = kTRUE; }
    void DisablePreCuts()                { fDisablePreCuts = kTRUE; }
    void SetPreCuts(Float_t radcutlow, Float_t radcuthigh, Float_t devcuthigh,
		    Float_t musizecutlow, Float_t arcphicutlow);

    void SetNameCerPhotEvt(const char *name) { fNameCerPhot = name; }

    void FillHist();
    void CalcPhi();
    void CalcImpact(Int_t effbinnum, Float_t startfitval, Float_t endfitval);
    Float_t CalcWidth();
    Int_t   Calc(const Float_t *cuts);

    ClassDef(MMuonCalibParCalc, 0) // task to calculate muon parameters
};

#endif

