#ifndef MARS_MJCalibrateSignal
#define MARS_MJCalibrateSignal

#ifndef MARS_MJob
#include "MJob.h"
#endif

class TEnv;
class TList;

class MTask;
class MParList;
class MGeomCam;
class MSequence;
class MExtractor;
class MPedestalCam;
class MBadPixelsCam;

class MJCalibrateSignal : public MJob
{
private:
    Bool_t fIsDataCheck;

    Bool_t CheckEnvLocal();

    Bool_t WriteResult();
    Bool_t ReadCalibration(TObjArray &o, MBadPixelsCam &bpix,
                           MExtractor* &ext1, MExtractor* &ext2, TString &geom) const;

    Bool_t IsDataCheck() const { return fIsDataCheck; }
    void SetDataCheck(Bool_t b) { fIsDataCheck = b; }

public:
    MJCalibrateSignal(const char *name=NULL, const char *title=NULL);

    Bool_t ProcessFile(MPedestalCam &camab, MPedestalCam &cam2/*, MPedestalCam &cam2*/);

    ClassDef(MJCalibrateSignal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
