#ifndef MARS_MDisp
#define MARS_MDisp

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MDisp : public MParContainer
{
private:

    TArrayD fParameters;      // Disp parameters
    TArrayD fStepsizes;       // step sizes of Disp parameters

    Double_t fLogSize0;       // Variables introduced in the Disp expression
    Double_t fLength0;        // to shift the minimization around the mean
    Double_t fWidth0;         // values of the variables, so it makes easier
    Double_t fConc0;          // to MINUIT to converge. Default values are set
    Double_t fLeakage10;      // in the constructor (to their standard mean 
    Double_t fLeakage20;      // distribution values) but can be changed with
                              // the set functions.

public:

    MDisp(const char *name=NULL, const char *title=NULL);

    void InitParameters();

    Bool_t SetParameters(const TArrayD &d);
    Bool_t SetStepsizes(const TArrayD &d);

    const TArrayD &GetParameters() const   { return fParameters; }
    const TArrayD &GetStepsizes()  const   { return fStepsizes;  }

    void SetLogSize0(Double_t newmeanval)  { fLogSize0  = newmeanval; }
    void SetWidth0(Double_t newmeanval)    { fWidth0    = newmeanval; }
    void SetLength0(Double_t newmeanval)   { fLength0   = newmeanval; }
    void SetConc0(Double_t newmeanval)     { fConc0     = newmeanval; }
    void SetLeakage10(Double_t newmeanval) { fLeakage10 = newmeanval; }
    void SetLeakage20(Double_t newmeanval) { fLeakage20 = newmeanval; }

    Double_t Calc(TArrayD &imagevar);

    ClassDef(MDisp, 1) // Container for the Disp parameters
};

#endif



