#ifndef MARS_MTriggerPattern
#define MARS_MTriggerPattern

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MTriggerPattern : public MParContainer
{
    friend class MTriggerPatternDecode;

public:
    enum Pattern_t {
        kTriggerLvl1 = BIT(1),
        kCalibration = BIT(2), // Pulse Trigger
        kTriggerLvl2 = BIT(3), // LUT Pseudo Size selection
        kPedestal    = BIT(4),
        kPinDiode    = BIT(5)
        //kUnused      = BIT(6)
        //kUnused      = BIT(7)
        //kUnused      = BIT(8)
    };

private:
    Byte_t fPrescaled;   // Bit Pattern as defined above
    Byte_t fUnprescaled; // Bit Pattern as defined above

public:
    MTriggerPattern(const char *name, const char *title);

    Byte_t GetPrescaled() const   { return fPrescaled; }
    Byte_t GetUnprescaled() const { return fUnprescaled; }

    ClassDef(MTriggerPattern, 1) // Container storing the decoded trigger pattern
};

#endif
