#ifndef MARS_MCalibrationIntensityChargeCam
#define MARS_MCalibrationIntensityChargeCam

#ifndef MARS_MCalibrationIntensityCam
#include "MCalibrationIntensityCam.h"
#endif

#ifndef MARS_MCalibrationChargeCam
#include "MCalibrationChargeCam.h"
#endif

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class TGraphErrors;
class TH2F;
class MGeomCam;

class MCalibrationIntensityChargeCam : public MCalibrationIntensityCam
{
private:

  void Add(const UInt_t a, const UInt_t b);

public:

  MCalibrationIntensityChargeCam(const char *name=NULL, const char *title=NULL);

  // Setters   
  void  SetFFactorMethodValid           ( const Bool_t  b=kTRUE ) {
    ((MCalibrationChargeCam*)GetCam())->SetFFactorMethodValid(b); }
  void  SetNumPhotonsBlindPixelMethod   ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsBlindPixelMethod(f); } 
  void  SetNumPhotonsFFactorMethod      ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsFFactorMethod   (f); }      
  void  SetNumPhotonsPINDiodeMethod     ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsPINDiodeMethod  (f); }   
  void  SetNumPhotonsBlindPixelMethodErr( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsBlindPixelMethodErr(f); } 
  void  SetNumPhotonsFFactorMethodErr   ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsFFactorMethodErr(f); }      
  void  SetNumPhotonsPINDiodeMethodErr  ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsPINDiodeMethodErr(f); }   

  Int_t CountNumValidEntries(const UInt_t pixid, const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE) const;
  
  TGraphErrors *GetRazmikPlot( const UInt_t pixid );
  TGraphErrors *GetPheVsCharge( const UInt_t pixid, const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE);
  TGraphErrors *GetPhePerCharge( const UInt_t pixid, const MGeomCam &geom, const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE);
  TGraphErrors *GetPhePerChargePerArea( const Int_t aidx, const MGeomCam &geom, const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE);
  TGraphErrors *GetPheVsChargePerArea( const Int_t aidx, const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE);
  TH2F         *GetRazmikPlotResults( const Int_t aidx, const MGeomCam &geom );
  
  ClassDef(MCalibrationIntensityChargeCam, 1) // Container Intensity Charge Calibration Results Camera
};

#endif
