#ifndef MARS_MFindDisp
#define MARS_MFindDisp

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MHMatrix;
class MDispCalc;
class MFDisp;
class MFilter;
class MH3;
class MGeomCam;
class MEvtLoop;

class MFindDisp : public MParContainer
{
private:

  TString   fFilenameParam;  // filename to store optimum Disp parameters

  TString   fFilenameTrain;
  TString   fFilenameTest;

  Int_t     fHowManyTrain;   // number of events for training
  Int_t     fHowManyTest;    // number of events for testing

  MHMatrix  *fMatrixTrain;   // training matrix
  MHMatrix  *fMatrixTest;    // testing matrix

  MDispCalc *fDispCalcTrain;
  MDispCalc *fDispCalcTest;

  MFDisp    *fDispFilter;    // filter to select an events sample

  MGeomCam  *fCam;

  MEvtLoop  *fObjectFit;

  //--------------------------------------------
  // To comunicate with MINUIT
  //--------------------------------------------
  // attention : dimensions must agree with those in 
  //             MMinuitInterface::CallMinuit()
  //char  fParName [80][100];
  TArrayD   fVinit;
  TArrayD   fStep;
  TArrayD   fLimlo;
  TArrayD   fLimup;
  TArrayI   fFix;

  UInt_t    fNpar;

  TString   fMethod;

  Double_t  fMin,   fEdm,   fErrdef;
  Int_t     fNpari, fNparx, fIstat;
  Int_t     fErrMinimize;
  //--------------------------------------------

public:

  MFindDisp(MFDisp *fdisp=NULL, const char *name=NULL, const char *title=NULL);
  ~MFindDisp();

  void SetFilenameParam(const TString &name)    {fFilenameParam  = name;}

  void SetFilenameTraining(const TString &name, const Int_t howmany) 
      {fFilenameTrain = name;  fHowManyTrain = howmany; }

  void SetFilenameTest(const TString &name, const Int_t howmany)     
      {fFilenameTest     = name;  fHowManyTest  = howmany; }

  Bool_t DefineTrainMatrix(const TString &name, MH3 &href,
                           const Int_t howmany, const TString &filetrain,
			   Int_t iflag=0); 

  Bool_t DefineTestMatrix(const TString &name, MH3 &href,
                          const Int_t howmany, const TString &filetest,
			  Int_t iflag=0); 

  Bool_t DefineTrainTestMatrix(const TString &name, MH3 &href,
			       const Int_t howmanytrain, const Int_t howmanytest, 
			       const TString &filetrain, const TString &filetest,
			       Int_t iflag=0); 

  MHMatrix *GetMatrixTrain() { return fMatrixTrain; }
  MHMatrix *GetMatrixTest()  { return fMatrixTest;  }

  Bool_t ReadMatrix( const TString &filetrain, const TString &filetest);

  Bool_t FindParams(TString parSCinit, TArrayD &params, TArrayD &steps);

  Bool_t TestParams();

  ClassDef(MFindDisp, 1) // Class for optimizing Disp
};

#endif



















