#ifndef MARS_MDispCalc
#define MARS_MDispCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MSrcPosCam;
class MHillas;
class MHillasExt;
class MNewImagePar;
class MMcEvt;
class MPointingPos;
class MImageParDisp;
class MDisp;
class MHMatrix;
class MParList;

class MDispCalc : public MTask
{
private:

    MSrcPosCam    *fSrcPos;
    MHillas       *fHil;
    MHillasExt    *fHilExt;
    MNewImagePar  *fNewPar;
    MMcEvt        *fMcEvt;
    MPointingPos  *fPointing;      // NOTE: take (theta,phi) from this container
                                   // when it is available (MC calibrated files 
                                   // or data files)

    MImageParDisp *fImageParDisp;  //! output container for Disp
    MDisp         *fDisp;          //  container for Disp parameters

    TString  fImageParDispName;    // name of container to store Disp
    TString  fDispName;            // name of container for Disp parameters

    Double_t fMm2Deg;              // conversion factor from mm to deg

    MHMatrix *fMatrix;             // matrix defined to have as much columns as 
                                   // variables wanted to be accessible during
                                   // Disp optimization, and as much rows as 
                                   // events used for the optimization
                                   // (filled at MFindDisp)

    TArrayI  fMap;                 // array to store the matrix mapping column
                                   // numbers corresponding to each added variable


    Int_t PreProcess(MParList *pList);
    Int_t Process();

    Double_t GetVal(Int_t i) const; // get value of variable entered in the matrix
                                    // at column fMap[i]


public:

    MDispCalc(const char *imagepardispname = "MImageParDisp",
	      const char *dispname         = "MDisp",
              const char *name=NULL, const char *title=NULL);

    void InitMapping(MHMatrix *mat);       // define the matrix of variables
    MHMatrix* GetMatrixMap(TArrayI &map);  // get matrix and its mapping array

    ClassDef(MDispCalc, 0) // Task to evaluate Disp
};

#endif












