/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Abelardo Moralejo 1/2005 <mailto:moralejo@pd.infn.it>!
!
!   Copyright: MAGIC Software Development, 2000-2003
! 
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////////////////////
//
// Macro trainsubsample.C
//
// Reads a star file from real data, and makes a subsample of it, adding a "fake" 
// MMcEvt container with MMcEvt.fPartId=14. This intended to produce, from real data,
// a "hadron training file" to be used in random forest (or other) g/h separation. The 
// MMcEvt container is added so that whatever the method will consider these (real) 
// showers to be all protons (before cuts, most will be, even in the case of strong 
// source as Crab).
//
/////////////////////////////////////////////////////////////////////////////////////

void trainsubsample()
{
  MParList plist;
  MTaskList tlist;

  plist.AddToList(&tlist);

  MReadMarsFile  read("Events", "star_20040915_CrabNebulaW1.root");

  MFEventSelector evsel;
  evsel.SetSelectionRatio(0.05); // Fraction of events in output

  read.DisableAutoScheme();
  tlist.AddToList(&read);

  MMcEvt* mcevt = new MMcEvt;
  mcevt->SetPartId(14);
  plist.AddToList(mcevt);

  MWriteRootFile write("star_train_20040915_CrabNebulaW1.root", "recreate");

  write.AddContainer("MMcEvt",         "Events", kFALSE);
  write.AddContainer("MHillas",        "Events");
  write.AddContainer("MHillasExt",     "Events");
  write.AddContainer("MImagePar",      "Events");
  write.AddContainer("MNewImagePar",   "Events");
  write.AddContainer("MHillasSrc",     "Events");
  write.AddContainer("MConcentration", "Events", kFALSE);
  write.AddContainer("MPointingPos",   "Events", kFALSE);


  write.AddContainer("MGeomCam",            "RunHeaders", kFALSE);
  write.AddContainer("MMcConfigRunHeader",  "RunHeaders", kFALSE);
  write.AddContainer("MMcCorsikaRunHeader", "RunHeaders", kFALSE);
  write.AddContainer("MMcFadcHeader",       "RunHeaders", kFALSE);
  write.AddContainer("MMcTrigHeader",       "RunHeaders", kFALSE);

  write.AddContainer("MRawRunHeader",       "RunHeaders");
  write.AddContainer("MSrcPosCam",          "RunHeaders");
  write.AddContainer("MMcRunHeader",        "RunHeaders", kFALSE);

  write.SetFilter(&evsel);

  tlist.AddToList(&evsel);
  tlist.AddToList(&write);

  MEvtLoop evtloop;
  evtloop.SetParList(&plist);

  MProgressBar *bar = new MProgressBar;
  evtloop.SetProgressBar(bar);

  //
  // Execute your analysis
  //
  if (!evtloop.Eventloop())
    return;

  tlist.PrintStatistics();

  bar->DestroyWindow();

  return;
}
