#ifndef MARS_MFTriggerPattern
#define MARS_MFTriggerPattern

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MTriggerPattern;

class MFTriggerPattern : public MFilter
{
private:
    MTriggerPattern *fPattern;        //!

    Byte_t fMaskRequiredPrescaled;    // Mask for filtering Trigger Pattern allowed
    Byte_t fMaskRequiredUnprescaled;  // Mask for filtering Trigger Pattern allowed
    Byte_t fMaskDeniedPrescaled;      // Mask for filtering Trigger Pattern denied
    Byte_t fMaskDeniedUnprescaled;    // Mask for filtering Trigger Pattern denied

    Bool_t fResult;                   //!

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    Bool_t IsExpressionTrue() const;

public:
    MFTriggerPattern(const char *name=NULL, const char *title=NULL);
    MFTriggerPattern(MFTriggerPattern &trigpatt);

    void RequireTriggerLvl1(Bool_t prescaled=kFALSE);
    void RequireTriggerLvl2(Bool_t prescaled=kFALSE);
    void RequireCalibration(Bool_t prescaled=kFALSE);
    void RequirePedestal(Bool_t prescaled=kFALSE);
    void RequirePinDiode(Bool_t prescaled=kFALSE);

    void DenyTriggerLvl1(Bool_t prescaled=kFALSE);
    void DenyTriggerLvl2(Bool_t prescaled=kFALSE);
    void DenyCalibration(Bool_t prescaled=kFALSE);
    void DenyPedestal(Bool_t prescaled=kFALSE);
    void DenyPinDiode(Bool_t prescaled=kFALSE);

    void Require(TString patt, Bool_t prescaled=kFALSE);
    void Deny(TString patt, Bool_t prescaled=kFALSE);

    // Low level settings. USE THESE ONLY IF YOU ARE AN EXPERT!
    void SetMaskRequired(const Byte_t mask, Bool_t prescaled=kFALSE);
    void SetMaskDenied(const Byte_t mask, Bool_t prescaled=kFALSE);

    ClassDef(MFTriggerPattern, 1) // A Filter for the Trigger Pattern
};

#endif
