#ifndef MARS_MReportStarguider
#define MARS_MReportStarguider

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MReportStarguider : public MReport
{
private:
    Double_t fDevAz;  // [deg]   azimuth mispointing
    Double_t fDevZd;  // [deg]   zenith  mispointing

    Int_t InterpreteBody(TString &str, Int_t ver);

public:
    MReportStarguider();

    Double_t GetDevAz() const { return fDevAz; }
    Double_t GetDevZd() const { return fDevZd; }

    void Print(Option_t *o="") const;

    ClassDef(MReportStarguider, 1) // Class for STARG-REPORT information
};

#endif
