#ifndef MARS_MCalibrationIntensityHiLoCam
#define MARS_MCalibrationIntensityHiLoCam

#ifndef MARS_MCalibrationIntensityCam
#include "MCalibrationIntensityCam.h"
#endif

#ifndef MARS_MCalibrationIntensityChargeCam
#include "MCalibrationIntensityChargeCam.h"
#endif

class TGraphErrors;
class MCalibrationIntensityHiLoCam : public MCalibrationIntensityCam
{
private:

  void Add(const UInt_t from, const UInt_t to);

public:

  MCalibrationIntensityHiLoCam(const char *name=NULL, const char *title=NULL);

  TGraphErrors *GetHiLoRatioVsCharge( const UInt_t pixid, const MCalibrationIntensityChargeCam &chargecam,
                                    const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE);
  TGraphErrors *GetHiLoRatioVsChargePerArea( const Int_t aidx, const MCalibrationIntensityChargeCam &chargecam,
                                           const MGeomCam &geom,
                                           const MCalibrationCam::PulserColor_t col=MCalibrationCam::kNONE);

  ClassDef(MCalibrationIntensityHiLoCam, 1) // Container Intensity HiLo Calibration Results Camera
};

#endif
