#ifndef MARS_MMuonSearchParCalc
#define MARS_MMuonSearchParCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHillas;
class MMuonSearchPar;
class MGeomCam;
class MCerPhotEvt;

class MMuonSearchParCalc : public MTask
{
private:
    MGeomCam    *fGeomCam;
    MCerPhotEvt *fCerPhotEvt;
    MHillas     *fHillas;      //! Pointer to the source independent hillas parameters
    MMuonSearchPar *fMuonPar;  //! Pointer to the output container for the new image parameters

    TString fMuparName;
    TString fHillasInput;
    TString fCerPhotName;

    Int_t PreProcess(MParList *plist);
    Int_t Process();

public:
    MMuonSearchParCalc(const char *mupar="MMuonSearchPar",
		       const char *name=NULL, const char *title=NULL);

    void SetInput(TString hilname) { fHillasInput = hilname; }

    void SetNameCerPhotEvt(const char *name) { fCerPhotName = name; }

    ClassDef(MMuonSearchParCalc, 0) // task to calculate muon parameters
};

#endif

