#ifndef MTASKLIST_H
#define MTASKLIST_H

#include "Magic.h"

#include <TOrdCollection.h>

#include "MTask.h"

class MParList;
class MInputStreamID;

class MTaskList : public MTask
{
private:
    TOrdCollection fTasks;	// Container for the ordered list of different tasks

    MInputStreamID *fID;

public:
    MTaskList();

    MTaskList(MTaskList &ts);

    Bool_t AddToList(MTask *task, const char *tType="All", MTask *where = NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void Print(Option_t *t = NULL);

    ClassDef(MTaskList, 1)	// Collection of tasks to be performed in the eventloop
};

#endif
