#ifndef MARS_MHCalibrationChargeCam
#define MARS_MHCalibrationChargeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef MARS_MArrayI
#include "MArrayI.h"
#endif

#ifndef MARS_MArrayD
#include "MArrayD.h"
#endif

class TH1F;
class MRawEvtData;
class MExtractedSignalCam;
class MCalibrationChargePix;
class MHCalibrationChargePix;

class MHCalibrationChargeCam : public MHCalibrationCam
{
private:

  static const Int_t   fgChargeHiGainNbins;          //! Nr. bins of HiGain Histograms  (now set to:  550  )
  static const Axis_t  fgChargeHiGainFirst;          //! First Bin of HiGain Histograms (now set to: -100.5)
  static const Axis_t  fgChargeHiGainLast;           //! Last Bin of HiGain Histograms  (now set to:  999.5)
  static const Int_t   fgChargeLoGainNbins;          //! First Bin of LoGain Histograms (now set to:  325  )
  static const Axis_t  fgChargeLoGainFirst;          //! First Bin of LoGain Histograms (now set to: -150.5)
  static const Axis_t  fgChargeLoGainLast;           //! Last Bin of LoGain Histograms  (now set to:  499.5)
  static const Float_t fgProbLimit;                  //! The default for fProbLimit    (now set to: 0.00001)
  
  static const TString gsHistName;                   //! Default Histogram names
  static const TString gsHistTitle;                  //! Default Histogram titles
  static const TString gsHistXTitle;                 //! Default Histogram x-axis titles
  static const TString gsHistYTitle;                 //! Default Histogram y-axis titles
  
  static const TString gsAbsHistName;               //! Default Histogram names abs.times
  static const TString gsAbsHistTitle;              //! Default Histogram titles abs.times
  static const TString gsAbsHistXTitle;             //! Default Histogram x-axis titles abs.times
  static const TString gsAbsHistYTitle;             //! Default Histogram y-axis titles abs.times
  
  static const Float_t fgNumHiGainSaturationLimit;   //! The default for fNumHiGainSaturationLimit (now at: 0.01)
  static const Float_t fgNumLoGainSaturationLimit;   //! The default for fNumLoGainSaturationLimit (now at: 0.005)

  static const Float_t fgTimeLowerLimit;             //! Default for fTimeLowerLimit    (now set to: 1.) 
  static const Float_t fgTimeUpperLimit;             //! Default for fTimeUpperLimit    (now set to: 2.)
  
  static const Float_t gkHiGainInnerRefLines[7];     //!
  static const Float_t gkHiGainOuterRefLines[7];     //!
  static const Float_t gkLoGainInnerRefLines[7];     //!
  static const Float_t gkLoGainOuterRefLines[7];     //!

  Int_t   fLoGainNbins;                              // Number of LoGain bins        
  Axis_t  fLoGainFirst;                              // Lower histogram limit low gain
  Axis_t  fLoGainLast;                               // Upper histogram limit low gain  

  TString fAbsHistName;                              // Histogram names abs.times
  TString fAbsHistTitle;                             // Histogram titles abs. times
  TString fAbsHistXTitle;                            // Histogram x-axis titles abs. times
  TString fAbsHistYTitle;                            // Histogram y-axis titles abs. times
  
  MArrayD fSumhiarea  ;                              //!
  MArrayD fSumloarea  ;                              //!
  MArrayD fTimehiarea ;                              //!
  MArrayD fTimeloarea ;                              //!
  MArrayD fSumhisector;                              //!
  MArrayD fSumlosector;                              //!
  MArrayD fTimehisector;                             //!
  MArrayD fTimelosector;                             //!

  MArrayI fSathiarea  ;                              //!
  MArrayI fSatloarea  ;                              //!
  MArrayI fSathisector;                              //!
  MArrayI fSatlosector;                              //!

  Float_t fTimeLowerLimit;            // Limit dist. to first signal slice (in units of FADC slices) 
  Float_t fTimeUpperLimit;            // Limit dist. to last signal slice  (in units of FADC slices) 
  Byte_t  fFirstHiGain;               // First used slice High Gain 
  Byte_t  fLastHiGain;                // Last used slice High Gain
  Byte_t  fFirstLoGain;               // First used slice Low Gain
  Byte_t  fLastLoGain;                // Last used slice Low Gain
  
  MRawEvtData         *fRawEvt;       //!  Raw event data 

  Bool_t SetupHists(const MParList *pList);
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);

  void   InitHiGainArrays( const Int_t npix, const Int_t nareas, const Int_t nsectors );
  void   InitLoGainArrays( const Int_t npix, const Int_t nareas, const Int_t nsectors );

  void   FinalizeAbsTimes (MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad,
                           Byte_t first, Byte_t last);  
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();

  void   DrawDataCheckPixel(MHCalibrationChargePix &pix, const Float_t refline[]);
  void   DisplayRefLines   ( const TH1F *hist,           const Float_t refline[]) const;

  Int_t ReadEnv        ( const TEnv &env, TString prefix, Bool_t print);
  
public:

  MHCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeCam() {}
  
  // Clone
  TObject *Clone(const char *name="") const;

  void SetLoGainNbins       ( const Int_t  i )       { fLoGainNbins   = i; }
  void SetLoGainFirst       ( const Axis_t f )       { fLoGainFirst   = f; }
  void SetLoGainLast        ( const Axis_t f )       { fLoGainLast    = f; }  

  void SetTimeLowerLimit    ( const Float_t f=fgTimeLowerLimit ) { fTimeLowerLimit = f; }
  void SetTimeUpperLimit    ( const Float_t f=fgTimeUpperLimit ) { fTimeUpperLimit = f; }
  
  void SetAbsHistName  ( const char *name )  { fAbsHistName  = name;  }
  void SetAbsHistTitle ( const char *name )  { fAbsHistTitle = name;  }
  void SetAbsHistXTitle( const char *name )  { fAbsHistXTitle = name; }
  void SetAbsHistYTitle( const char *name )  { fAbsHistYTitle = name; }
   
  Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const { return kTRUE; }
  void   DrawPixelContent( Int_t num )  const;    

  // Draw
  void   Draw(const Option_t *opt);

  ClassDef(MHCalibrationChargeCam, 1)	// Histogram class for Charge Camera Calibration 
};

#endif
