//************************************************************************
//
// Authors : Eva Domingo,     1/2005 <mailto:domingo@ifae.es>
//
//
// Macro for generating DISP Skymap of the FoV
// -------------------------------------------
//
//************************************************************************

void DispSkymap(TString filename = "hillasfile.root")
{
  //======================================================================
  // Make Disp plots
  //======================================================================
  
  gLog << "-----------------------------------------------------" << endl; 
  gLog << "Make Disp related plots" << endl;
  gLog << "-----------------------------------------------------" << endl; 
  
  // Input root file/s storing the computed Hillas and Disp parameters
  gLog << "Input file/s: " <<  filename << endl;
  
  //----------------------------------------------------
  MTaskList tlist;
  MParList  plist;
  
  //      MReadMarsFile read("Events", filename);
  MReadTree read("Parameters", filename);
  read.DisableAutoScheme();
  
  MGeomCamMagic geomcam;

  // set cuts to select an event sample to apply Disp
  MFDisp *fdisp = NULL;
  //      fdisp = new MFDisp;
  //      fdisp->SetCuts(0,1,7,600,0,600,0.,3000000.,0.,0.,0.,0.,0.,0.);
  //      MContinue contdisp(fdisp);
  
  // make Disp plots
  // SelectedPos = 1  means choose the right source position
  //               2                   wrong
  //               3               the position according to M3Long
  //               4               the position according to Asym
  MHDisp hdisp1;
  hdisp1.SetName("MHDispCorr");
  hdisp1.SetSelectedPos(1);
  MFillH filldisp1("MHDispCorr[MHDisp]", "");
  
  MHDisp hdisp2;
  hdisp2.SetName("MHDispWrong");
  hdisp2.SetSelectedPos(2);
  MFillH filldisp2("MHDispWrong[MHDisp]", "");
  
  MHDisp hdisp3;
  hdisp3.SetName("MHDispM3Long");
  hdisp3.SetSelectedPos(3);
  MFillH filldisp3("MHDispM3Long[MHDisp]", "");
  
  MHDisp hdisp4;
  hdisp4.SetName("MHDispAsym");
  hdisp4.SetSelectedPos(4);
  MFillH filldisp4("MHDispAsym[MHDisp]", "");
  
  
  //*****************************
  // entries in MParList
  plist.AddToList(&tlist);
  plist.AddToList(&geomcam);
  plist.AddToList(&hdisp1);
  plist.AddToList(&hdisp2);
  plist.AddToList(&hdisp3);
  plist.AddToList(&hdisp4);
  
  //*****************************
  // entries in MTaskList
  tlist.AddToList(&read);
  if (fdisp != NULL)
    tlist.AddToList(&contdisp);
  tlist.AddToList(&filldisp1);
  //  tlist.AddToList(&filldisp2);
  tlist.AddToList(&filldisp3);
  tlist.AddToList(&filldisp4);
  
  //*****************************
  
  //-------------------------------------------
  // Execute event loop
  //
  MProgressBar bar;
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
  evtloop.SetProgressBar(&bar);
  
  Int_t maxevents = -1;
  if ( !evtloop.Eventloop(maxevents) )
    return;
  
  tlist.PrintStatistics(0, kTRUE);
  
  //-------------------------------------------
  // Display the histograms
  //
  //  hdisp1.DrawClone();
  //  hdisp2.DrawClone();
  //  hdisp3.DrawClone();
  //  hdisp4.DrawClone();
  
  gLog << "Drawing DISP Skymap for the FoV (srcpos solution selected according Asym sign)..." << endl; 
  TCanvas *c = new TCanvas("c","Disp Skymap",0,0,900,900);    
  c->SetBorderMode(0);
  gStyle->SetPalette(1);
  TH2F *skymap = hdisp4.GetSkymapXY();
  skymap->SetTitleOffset(1.2,"Y");
  //  skymap->SetStats(0);
  skymap->DrawClone("COLZ");
  skymap->SetBit(kCanDelete);


  //-------------------------------------------
  gLog << endl << "Disp plots were made for file '" << filename << endl; 
  gLog << "-----------------------------------------------------" << endl; 

}










