#ifndef MNPHOTEVENT_H
#define MNPHOTEVENT_H

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#include <iostream>
#include <TROOT.h>
class TClonesArray ; 
class TObjArray ; 
class MCamNeighbor ; 

class MCerPhotPix : public TObject
{
 private:
  
  Int_t    fPixId     ;  //   the pixel Id
  Bool_t   fIsUsed    ;  //   the pixel is used for calculations --> kTRUE
  Bool_t   fIsCore    ;  //   the pixel is a Core pixel          --> kTRUE
  Float_t  fPhot      ;  //   The number of Cerenkov photons 
  Float_t  fErrPhot   ;  //   the error of fPhot
 
 public:
  
  MCerPhotPix(Int_t pix = -9999, Float_t phot=0. , Float_t errphot=0.) ; 

  void Print() ; 
  
  Int_t GetPixId() 
    {
      return fPixId ; 
    }
  
  Float_t GetPhotons()
    {
      return fPhot ; 
    }
  
  Float_t GetErrorPhot()
    {
      return fErrPhot ; 
    }
  
  void SetPixelContent(Int_t pix , Float_t phot , Float_t errphot ) ; 

  Bool_t IsPixelUsed() 
    { 
      return fIsUsed ; 
    }  
  
  void SetPixelUnused() 
    { 
      fIsUsed = kFALSE ; 
    }  
  
  void SetPixelUsed() 
    { 
      fIsUsed = kTRUE ; 
    }  
  
  void SetCorePixel() 
    { 
      fIsCore = kTRUE ; 
    } 

  Bool_t IsCorePixel() 
    { 
      return fIsCore ; 
    }  
  
  
  ClassDef(MCerPhotPix, 1)  // Cerenkov Photons class for the pixel
} ; 


// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class MCerPhotEvt : public MParContainer
{
 private: 

  Int_t            fType ;       // 
  Int_t            fNbPixels ;   // 
  TClonesArray     *fPixels   ;  //


  MCamNeighbor     *fNN  ;   //!   the class with the information about neighbors
  
 public:
  
  MCerPhotEvt(const char *name=NULL, const char *title=NULL) ; 

  void Draw(Option_t* option = "" ) ; 

  Int_t    GetNbPixels() ; 

  void AddPixel(Int_t id, Float_t nph, Float_t err );

  void Clear() ; 

  void Print() ; 

  void CleanLevel1() ; 
  void CleanLevel2() ; 
  void CleanLevel3() ; 
  
  Bool_t PixelExist( Int_t id ) ; 
  Bool_t PixelIsUsed( Int_t id ) ; 
  Bool_t PixelIsCore( Int_t id ) ; 
 
  Int_t GetPixelId(Int_t i ) ; 
  Bool_t  IsPixelUsed(Int_t i ) ;
  Float_t GetPhotons(Int_t i ) ; 
  Float_t GetErrorPhot(Int_t i ) ; 
  
  Float_t GetMinimumPhoton()  ;  
  Float_t GetMaximumPhoton()  ; 
 
  ClassDef(MCerPhotEvt, 1)    // class for Nphotons Events
}; 

#endif


