#include "MViewAdcSpectra.h" 

#include <iostream.h>

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawEvtData.h"
#include "MRawCrateArray.h"
#include "MTime.h"

#include "MReadTree.h" 
#include "MDumpEvtHeader.h" 
#include "MFillAdcSpect.h" 
#include "MShowSpect.h" 
#include "MHistosAdc.h" 

MViewAdcSpectra::MViewAdcSpectra() 
{
  // default constructor  
} 

MViewAdcSpectra::~MViewAdcSpectra() 
{
  // default destructor  
} 


// ================================================================================
Bool_t MViewAdcSpectra::AdcSpectra ( Char_t *inputfile, Char_t *treeName ) 
{
  //   This job reads in the FADC data from all events and fills
  //   the spectrum for each pmt pixel.
  //

  cout << "PedAdcSpectra:: Analyse the tree " << treeName 
       << "in the file  " << inputfile << endl ;
  
  // create a (empty) list of parameters which can be used by the tasks
  // and an (empty) list of tasks which should be executed
  // connect them in the required way. 
 
  MParList *plist  = new MParList;
  MTaskList *tasks = new MTaskList;
  plist->AddToList(tasks);

  //   create the data containers for the raw data 
  
  MRawRunHeader *runheader = new MRawRunHeader;
  plist->AddToList(runheader);

  MRawEvtHeader *evtheader = new MRawEvtHeader;
  plist->AddToList(evtheader);
  
  MRawEvtData *evtdata = new MRawEvtData;
  plist->AddToList(evtdata);
  
  MRawCrateArray *cratearray = new MRawCrateArray;
  plist->AddToList(cratearray);
  
  MTime *evttime = new MTime("MTime");
  plist->AddToList(evttime);

  MHistosAdc *histosAdc = new MHistosAdc() ; 
  plist->AddToList( histosAdc ) ; 
  
  //    set up the tasks for this job

  MReadTree *readin  =  new MReadTree ( inputfile, treeName ) ; 
  tasks->AddToList( readin ) ; 

  //  MDumpEvtHeader *dumpheader = new MDumpEvtHeader() ; 
  //  tasks->AddToList( dumpheader ) ; 
 
  MFillAdcSpect *fillspect = new MFillAdcSpect() ; 
  tasks->AddToList( fillspect ) ; 

  MShowSpect *showspect = new MShowSpect( "MHistosAdc" ) ; 
  tasks->AddToList( showspect ) ;

  //    set up the loop for the processing 
  
  MEvtLoop magic;
  magic.SetParList(plist);

  //    start the loop running 

  magic.Eventloop() ; 
  

  cout << " End of this job " << endl ; 

  return kTRUE ; 

} 
