#ifndef MCAMDISPLAY_H
#define MCAMDISPLAY_H

#include <iostream>

#include "MAGIC.h"

#define   ITEMS_LEGEND         25 

class TClonesArray ; 
class MCerPhotEvt  ; 

class MCamDisplay : public TObject
{
 private: 
  Bool_t        fAutoScale ;  //  indicating the autoscale function
  
  Int_t         fNbPixels ;   // 
  TClonesArray  *fPixels   ;  //!

  Float_t       fMinPhe ;     //  The minimal number of Phe
  Float_t       fMaxPhe ;     //  The maximum number of Phe 

  TClonesArray  *fLegend  ;    //! 
  TClonesArray  *fLegText ;    //! 

 public:
  
  MCamDisplay ( Int_t type=0 ) ; 

  ~MCamDisplay () ; 

  void Init() ;

  void Draw(Option_t *option = "" ) ; 

  void Draw( MCerPhotEvt *event) ; 
  void DrawError( MCerPhotEvt *event) ; 

  void Reset() ; 

  Int_t GetColor( Float_t wert ) ; 

  void UpdateLegend() ;  

  void SetAutoScale (Bool_t input = kTRUE ) 
    { 
      fAutoScale = input ; 
    } 

  //Int_t    GetNbPixels() ; 
  
  ClassDef(MCamDisplay, 1)		// Base (abstract) class for a task
};

#endif
