#include "MFileDescr.h"

#include <iostream.h>

#include <TFile.h>
#include <TTree.h>

#include "MParContainer.h"

void MRootFileIn::SetAddress(MParContainer **obj)
{
    pBranchIn->SetAddress(obj);
}

void MRootFileIn::GetEvent(Int_t n)
{
    pTreeIn->GetEvent(n);
}

void MRootFileOut::SetAddress(MParContainer **obj)
{
    pBranchOut->SetAddress(obj);
}

void MRootFileOut::Fill()
{
    pTreeOut->Fill();
}

MRootFileIn::MRootFileIn(TFile *f, const char *fName, const char *cname)
{
    //
    // Open the tree in the input file with the same name than
    // this instance
    //
    cout << "Open Tree: " << fName << "... " << flush;
    pTreeIn = (TTree *) f->Get(fName);

    if (!pTreeIn)
        cout << "WARNING: Cannot open tree " << fName << "." << endl;

    //
    // Open the branch in the tree with the same name than
    // the ClassName of the objects in the buffer
    //
    cout << "Branch: " << cname << "... " << flush;
    pBranchIn = pTreeIn->GetBranch(cname);

    if (!pBranchIn)
        cout << "WARNING: Cannot open branch " << cname << "." << endl;
    else
        cout << "Done." << endl;

    cout << endl;

    //
    // get number events in branch
    //
    // nEvts = pTreeIn->GetEntries();
}

MRootFileOut::MRootFileOut(const char *fName, const char *cname, MParContainer **obj)
{
    //
    // Open the tree in the output file with the same name than
    // the this instance
    //
    cout << "Create Tree: " << fName << "... " << flush;
    TTree *pTreeOut = new TTree(fName, ""/*fTitle*/);

    if (!pTreeOut)
        cout << "WARNING: Cannot open tree " << fName << "." << endl;


    //
    // Create the branch in the tree with the same name than
    // the ClassName of the objects in the buffer
    //
    cout << "Branch: " << cname << "... " << flush;
    pBranchOut = pTreeOut->Branch("TEST", cname, obj, 100000, 10);

    if (!pBranchOut)
        cout << "WARNING: Cannot open branch " << cname << "." << endl;
    else
        cout << "Done." << endl;

    cout << endl;
}

MMagicFileIn::MMagicFileIn(const char *fname)
{
    fin = new fstream(fname, ios::in);
    if (!fin)
        cout << "Warning: Cannot open file '" << fname << "' for reading." << endl;
}

MMagicFileIn::~MMagicFileIn()
{
    if (fin)
        delete fin;
}

void MMagicFileIn::SetAddress(MParContainer **obj)
{
    fContainer = *obj;
}

void MMagicFileIn::GetEvent(Int_t n)
{
    if (n!=0)
        cout << "Warning: You cannot seek inside a Magic file <n ignored>" << endl;

    fContainer->GetEventFromMagicFile(*fin);
}

MMagicFileOut::MMagicFileOut(const char *fname, MParContainer **obj)
{
    fout = new fstream(fname, ios::out);
    //fFile = fopen(fname, "w");
    if (!fout)
        cout << "Warning: Cannot open file '" << fname << "' for writing." << endl;
}

MMagicFileOut::~MMagicFileOut()
{
    if (fout)
        delete fout;
}

void MMagicFileOut::SetAddress(MParContainer **obj)
{
    fContainer = *obj;
}

void MMagicFileOut::Fill()
{
    fContainer->PutEventToMagicFile(*fout);
}
