#ifndef MARS_MFDisp
#define MARS_MFDisp

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MHillas;
class MHillasSrc;
class MImagePar;
class MNewImagePar;

class MFDisp : public MFilter
{
private:

    MHillas      *fHil;
    MHillasSrc   *fHilSrc;
    MImagePar    *fImgPar;
    MNewImagePar *fNewImgPar;

    //--------------------------    

    // cutting variables to select the sample
    // for the Disp optimization

    Int_t      fIslandsMin;
    Int_t      fIslandsMax;

    Int_t      fUsedPixelsMin;
    Int_t      fUsedPixelsMax;

    Int_t      fCorePixelsMin;
    Int_t      fCorePixelsMax;

    Float_t      fSizeMin;
    Float_t      fSizeMax;

    Float_t      fLeakage1Min;
    Float_t      fLeakage1Max;

    Float_t      fLeakage2Min;
    Float_t      fLeakage2Max;

    Float_t      fLengthMin;
    Float_t      fWidthMin;

    //--------------------------    

    Double_t     fMm2Deg;     // conversion mm to degrees in camera

    Int_t        fCut[8];     // array to save cuts statistics

    Bool_t       fResult;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    Bool_t IsExpressionTrue() const  { return fResult; }

    Bool_t Set(Int_t rc);

public:

    MFDisp(const char *name=NULL, const char *title=NULL);

    void SetCuts(Int_t islandsmin,      Int_t islandsmax,
                 Int_t usedpixelsmin,   Int_t usedpixelsmax,
                 Int_t corepixelsmin,   Int_t corepixelsmax,
                 Float_t sizemin,       Float_t sizemax, 
                 Float_t leakage1min,   Float_t leakage1max,
                 Float_t leakage2min,   Float_t leakage2max,
                 Float_t lengthmin,     Float_t widthmin);

    ClassDef(MFDisp, 0)   // Class to set cuts for Disp optimization
};

#endif











