#ifndef MARS_MJCalib
#define MARS_MJCalib

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

class MRunIter;
class MJCalib
{
protected:

  MRunIter *fRuns;          // Data files, only used for test applications, default is sequence files!
  
  enum DataType_t
    {
      kIsUseRawData,
      kIsUseRootData,
      kIsUseMC
    };

  Byte_t    fDataFlag;      // Bit-field to store the data type
  
  Bool_t IsUseRawData()  const { return TESTBIT(fDataFlag,kIsUseRawData);  }
  Bool_t IsUseRootData() const { return TESTBIT(fDataFlag,kIsUseRootData); }
  Bool_t IsUseMC()       const { return TESTBIT(fDataFlag,kIsUseMC);       }
  
  void   SetUseRawData ( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseRawData)  : CLRBIT(fDataFlag,kIsUseRawData);  }
  void   SetUseRootData( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseRootData) : CLRBIT(fDataFlag,kIsUseRootData); }
  void   SetUseMC      ( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseMC)       : CLRBIT(fDataFlag,kIsUseMC);       }

public:

  MJCalib();
  
  void SetInput      ( MRunIter *iter       )  { fRuns = iter; }
  
  ClassDef(MJCalib, 0) // Base class for calibration jobs
};

#endif
