#ifndef MARS_MSequences
#define MARS_MSequences

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MRead;

class MSequences : public MParContainer
{
private:
    UInt_t fNumAnalysis;      // Analysis number (artificial)

    TArrayI fNumSequencesOn;  // number of on-sequences
    TArrayI fNumSequencesOff; // number of off-sequences

    TList fSequencesOn;       // list of names and paths of on-sequences
    TList fSequencesOff;      // list of names and paths of off-sequences

    void Split(TString &runs, TArrayI &data) const;
    void ResolveSequences(TEnv &env, const TArrayI &num, TList &list) const;
    static void PrintFile(const TObject &obj);

public:
    MSequences() : fNumAnalysis((UInt_t)-1) { }
    MSequences(const char *fname);

    void Print(Option_t *o="") const;

    Bool_t IsValid() const { return fNumAnalysis!=(UInt_t)-1; }

    static Bool_t AddSequencesToList(const TList &list, MRead &read, char *id="I", Bool_t raw=kFALSE);

    Bool_t AddFiles(MRead &read,    char *id="I", Bool_t raw=kFALSE) const;
    Bool_t AddFilesOn(MRead &read,  char *id="I", Bool_t raw=kFALSE) const;
    Bool_t AddFilesOff(MRead &read, char *id="I", Bool_t raw=kFALSE) const;

    UInt_t GetNumSequencesOn() const  { return fNumSequencesOn.GetSize(); }
    UInt_t GetNumSequencesOff() const { return fNumSequencesOff.GetSize(); }

    Bool_t HasOffSequences() const { return GetNumSequencesOff()>0; }

    // Getter
    UInt_t GetNumAnalysis() const { return fNumAnalysis; }
    void   SetNumAnalysis(UInt_t num) { fNumAnalysis=num; }

    ClassDef(MSequences, 0)
};

#endif
